#include <windows.h>
#include <gl/gl.h>
#include <math.h>
#include "wave.h"
#include "math3d.h"

struct map_t	hMap;
struct wave_t	*wave_lump=NULL;
float			wave_hmax;
int				numWave=0, numWave_max=0;
BOOL			dur=FALSE;

#define MI(w, l)		( (l)*hMap.nwidth + (w) )
#define MCI(w, l)		( (l)*(hMap.nwidth-1) + (w) )

void glmVertex( int w, int l )
{
	glVertex3f( hMap.vertex[ MI(w, l) ].x, 
				hMap.vertex[ MI(w, l) ].y, 
				hMap.vertex[ MI(w, l) ].z );
}

void glmNormal( int w, int l )
{
	glNormal3f( hMap.normal[ MI(w, l) ].x,
				hMap.normal[ MI(w, l) ].y,
				hMap.normal[ MI(w, l) ].z );
}

void glmTexture( int w, int l )
{
	glTexCoord2f(	hMap.texture[ MI(w, l) ].x,
					hMap.texture[ MI(w, l) ].y	);
}

void AddMapValue(int w, int l, float deger)
{
	hMap.vertex[ MI(w, l) ].y += deger;
}

void ResetHeightMap(void)
{
	int		iw, il;
	float	dw, dl;

	dw = hMap.width / (hMap.nwidth-1);
	dl = hMap.length / (hMap.nlength-1);

	for (il=0; il<hMap.nlength; il++)
	{
		for (iw=0; iw<hMap.nwidth; iw++)
		{
			hMap.vertex[ MI(iw, il) ].x = dw*iw;
			hMap.vertex[ MI(iw, il) ].y = 0;
			hMap.vertex[ MI(iw, il) ].z = dl*il;
		}
	}
}

void CompileWave(wave_t wave)
{
	int		wi, li;
	float	dl, dw, d, z, h, s, u;
	float	dww, dll, aci;

	dl = hMap.length / (hMap.nlength-1);
	dw = hMap.width / (hMap.nwidth-1);

	for (li=0; li<(hMap.nlength); li++)
	{
		for (wi=0; wi<(hMap.nwidth); wi++)
		{
			dww = wave.pos_w - hMap.vertex[ MI(wi, li) ].x;
			dll = wave.pos_l - hMap.vertex[ MI(wi, li) ].z;
			u = sqrtf( dww * dww + dll * dll );
			d = fabsf( wave.r - u );
			if ( d <= wave.e )
			{
				// Nokta ierde
				z = u - (wave.r - wave.e);
				h = fabsf(wave.e - d)*wave.hmax;
				//h = powf((wave.e - d),2)*wave.hmax;
				aci = (z*wave.lambda*(float)PI)/wave.e;
				s = sinf( aci );
				AddMapValue(wi, li, s*h);
			}
		}
	}
}

void CreateHeightMap(float width, int nwidth, float length, int nlength)
{
	int il, iw;

	hMap.vertex		= (vec3f_t *)malloc(sizeof(vec3f_t)*nwidth*nlength);
	hMap.texture	= (vec2f_t *)malloc(sizeof(vec2f_t)*nwidth*nlength);
	hMap.normal		= (vec3f_t *)malloc(sizeof(vec3f_t)*nwidth*nlength);
	hMap.normal1	= (vec3f_t *)malloc(sizeof(vec3f_t)*(nwidth-1)*(nlength-1));
	hMap.normal2	= (vec3f_t *)malloc(sizeof(vec3f_t)*(nwidth-1)*(nlength-1));
	hMap.center1	= (vec3f_t *)malloc(sizeof(vec3f_t)*(nwidth-1)*(nlength-1));
	hMap.center2	= (vec3f_t *)malloc(sizeof(vec3f_t)*(nwidth-1)*(nlength-1));
	hMap.length		= length;
	hMap.nlength	= nlength;
	hMap.width		= width;
	hMap.nwidth		= nwidth;

	for (il=0; il<hMap.nlength; il++)
	{
		for (iw=0; iw<hMap.nwidth; iw++)
		{
			hMap.texture[ MI(iw, il) ].x = (float)iw / (hMap.nwidth-1);
			hMap.texture[ MI(iw, il) ].y = 1 - ((float)il / (hMap.nlength-1));
		}
	}

	ResetHeightMap();
}

void CreateWaveLump(int wave_max, float r_vel_al, float e_al, float hmax_al, float lambda_al)
{
	int i;

	wave_lump		= (wave_t *)malloc(sizeof(wave_t)*wave_max);
	wave_hmax		= hmax_al;
	numWave_max		= wave_max;
	numWave			= wave_max;

	for (i=0; i<numWave_max; i++)
	{
		wave_lump[i].e				= e_al;
		wave_lump[i].lambda			= lambda_al;
		wave_lump[i].r				= 0.0f;
		wave_lump[i].r_vel			= r_vel_al;
	}
}

void DrawWaterSurface(void)
{
	int			iw, il;
	float		dl, dw;

	glPushMatrix();
	glTranslatef( -hMap.width/2, 0, -hMap.length/2);

	dl = hMap.length / (hMap.nlength-1);
	dw = hMap.width / (hMap.nwidth-1);

	for ( il=0; il < hMap.nlength-1; il++)
	{
		glBegin(GL_TRIANGLE_STRIP);

			for ( iw=0; iw < hMap.nwidth; iw++)
			{

			glmNormal( iw, il );	glmTexture(iw, il);		glmVertex( iw, il );
			glmNormal( iw, il+1 );	glmTexture(iw, il+1);	glmVertex( iw, il+1 );
			
			}

		glEnd();
	}
	
	glPopMatrix();
}

void WaveMainLoop(void)
{
	int i;

	if ( !dur )
	{
		// Dalga hareketleri
		for (i=0; i<numWave; i++)
		{
			wave_lump[i].r += wave_lump[i].r_vel;
			wave_lump[i].hmax -= 0.001f;
			if ( wave_lump[i].hmax <= 0.0001 )
			{
				wave_lump[i].hmax = 0.0f;
			}
		}
	}

	// Dalgalar haritaya yerletiriliyor
	ResetHeightMap();	// nce harita dzletirilir
	for (i=0; i<numWave; i++)
	{
		CompileWave( wave_lump[i] );
	}

	// Harita normalleri hesaplanr
	CalculateWaveNormals();
	//CalculateWaveCenters();

	// Harita dna kanlar yada ykseklii kalmayanlar tekrar oluturulur
	for (i=0; i<numWave; i++)
	{
		if ( (wave_lump[i].r > hMap.length && wave_lump[i].r > hMap.width) || wave_lump[i].hmax==0 )
		{
			wave_lump[i].hmax			= (rand()/32767.0f)*wave_hmax;
			wave_lump[i].pos_l			= (rand()/32767.0f)*hMap.length;
			wave_lump[i].pos_w			= (rand()/32767.0f)*hMap.width;
			wave_lump[i].r				= 0.0f;
		}
	}
}

void CalculateWaveCenters(void)
{
	int		il, iw;

	for ( il=0; il<(hMap.nlength-1); il++ )
	{
		for ( iw=0; iw<(hMap.nwidth-1); iw++ )
		{
			hMap.center1[ MCI(iw, il) ] = VecGetCenter(	hMap.vertex[ MI(iw, il) ],
														hMap.vertex[ MI(iw, il+1) ],
														hMap.vertex[ MI(iw+1, il) ] );

			hMap.center2[ MCI(iw, il) ] = VecGetCenter(	hMap.vertex[ MI(iw+1, il+1) ],
														hMap.vertex[ MI(iw, il+1) ],
														hMap.vertex[ MI(iw+1, il) ] );
		}
	}
}

void CalculateWaveNormals(void)
{
	int			il, iw;
	vec3f_t		v1, v2, vt6;
	//int			nw, nl;

	// Oluan genlerin normali hesaplanr
	for ( il=0; il<(hMap.nlength-1); il++ )
	{
		for ( iw=0; iw<(hMap.nwidth-1); iw++ )
		{
			v1 = VecSub( hMap.vertex[ MI(iw, il+1) ], hMap.vertex[ MI(iw, il) ] );
			v2 = VecSub( hMap.vertex[ MI(iw+1, il) ], hMap.vertex[ MI(iw, il) ] );

			hMap.normal1[ MCI(iw, il) ] = VecCross3f( v1, v2 );
			VecNormalize3f( &hMap.normal1[ MCI(iw, il) ] );

			v1 = VecSub( hMap.vertex[ MI(iw, il+1) ], hMap.vertex[ MI(iw+1, il+1) ] );
			v2 = VecSub( hMap.vertex[ MI(iw+1, il) ], hMap.vertex[ MI(iw+1, il+1) ] );

			hMap.normal2[ MCI(iw, il) ] = VecCross3f( v2, v1 );
			VecNormalize3f( &hMap.normal2[ MCI(iw, il) ] );

		}
	}

	// SMOOT SHADE iin her noktann ortalama normali hesaplanr
	//nw = hMap.nwidth;
	//nl = hMap.nlength;
	// Kelerdekiler
	//hMap.normal[ 0 ] = hMap.normal1[0];
	//hMap.normal[ MI( nw-1, nl-1 ) ] = hMap.normal2[ MCI( nw-2, nl-2 ) ];
	//hMap.normal[ MI( nw-1, 0 ) ] = VecTopla(	hMap.normal1[ MCI(nw-2,0) ], 
	//											hMap.normal2[ MCI(nw-2,0) ] );
	//hMap.normal[ MI(0, nl-1) ] = VecTopla(	hMap.normal1[ MCI(0, nl-2) ],
	//										hMap.normal2[ MCI(0, nl-2) ] );

	for ( il=1; il<(hMap.nlength-1); il++ )
	{
		for ( iw=1; iw<(hMap.nwidth-1); iw++ )
		{
			vt6.x = (hMap.normal2[ MCI(iw-1, il-1) ].x +
					hMap.normal1[ MCI(iw, il-1) ].x +
					hMap.normal2[ MCI(iw, il-1) ].x +
					hMap.normal1[ MCI(iw, il) ].x +
					hMap.normal2[ MCI(iw-1, il) ].x +
					hMap.normal1[ MCI(iw-1, il) ].x )/6.0f;

			vt6.y = (hMap.normal2[ MCI(iw-1, il-1) ].y +
					hMap.normal1[ MCI(iw, il-1) ].y +
					hMap.normal2[ MCI(iw, il-1) ].y +
					hMap.normal1[ MCI(iw, il) ].y +
					hMap.normal2[ MCI(iw-1, il) ].y +
					hMap.normal1[ MCI(iw-1, il) ].y )/6.0f;

			vt6.z = (hMap.normal2[ MCI(iw-1, il-1) ].z +
					hMap.normal1[ MCI(iw, il-1) ].z +
					hMap.normal2[ MCI(iw, il-1) ].z +
					hMap.normal1[ MCI(iw, il) ].z +
					hMap.normal2[ MCI(iw-1, il) ].z +
					hMap.normal1[ MCI(iw-1, il) ].z )/6.0f;

			VecNormalize3f( &vt6 );
			hMap.normal[ MI(iw, il) ] = vt6;
		}
	}
}