#ifndef __WAVE_H__
#define __WAVE_H__

#include "math3d.h"

#define PIBOL180	0.017453292519943295769236907684886
#define PI			3.1415926535897932384626433832795

extern dur;


struct wave_t
{
	float pos_w, pos_l;
	float r, r_vel;
	float e;
	float hmax;
	float lambda;
};

struct map_t{

	vec3f_t		*vertex;

	vec3f_t		*normal;
	vec3f_t		*normal1;
	vec3f_t		*normal2;

	vec2f_t		*texture;

	vec3f_t		*center1;
	vec3f_t		*center2;

	float		width, length;
	int			nwidth, nlength;

};

void	DrawWaterSurface(void);
void	CreateHeightMap(float width, int nwidth, float length, int nlength);
void	CompileWave(wave_t wave);
void	AddMapValue(int w, int l, float deger);
void	ResetHeightMap(void);
void	WaveMainLoop(void);
void	CreateWaveLump(int wave_max, float r_vel_al, float e_al, float hmax_al, float lambda_al);
void	CalculateWaveNormals(void);
void	CalculateWaveCenters(void);

#endif // __WAVE_H__