#include <gl/glut.h>
#include <math.h>

void draw_circ(int cx, int cy, float sweep_angle, float angle, float radius) {

  const int n = 500;
  float ang = sweep_angle * 3.14159265/180;
  float ang_inc = angle * 3.14159265/(180*n);
  int k;
  glBegin(GL_POINTS);
  for(k=1; k <= n; k++, ang+=ang_inc) 
    glVertex2f((GLfloat)cx+radius*cos(ang), (GLfloat)cy+radius*sin(ang));
  glEnd();

}

void draw_rect(int x, int y, int width, int height) {

  glBegin(GL_LINE_STRIP);
  glVertex2i(x, y);
  glVertex2i(x, y-height);
  glVertex2i(x+width, y-height);
  glVertex2i(x+width, y);
  glVertex2i(x, y);
  glEnd();
}

void init(void) {

  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluOrtho2D(-5.0, 5.0, -5.0, 5.0);
  glViewport(0, 0, 500, 500);
}

void draw_hyperbola() {
  
	float x;

  glBegin(GL_POINTS);

  for( x=-3.0; x<3.0; x+=0.01) {
		glVertex2f(x ,sqrt(x*x-1) );
		glVertex2f(x, -sqrt(x*x-1) );
		glVertex2f(-x, sqrt(x*x-1));
		glVertex2f(-x, -sqrt(x*x-1) );
	}

  glEnd();

}

void display(void) {

  int r=30.0;
  int x=10.0, y=10.0;

  glClearColor(1.0, 1.0, 1.0, 1.0);
  glClear(GL_COLOR_BUFFER_BIT);
  glColor3f(0.0, 0.0, 0.0);
  draw_hyperbola();
  glFlush();
glBegin(GL_LINES);
	glVertex2f(-5.0, 0.0);
	glVertex2f(5.0, 0.0);
	glVertex2f(0.0, 5.0);
	glVertex2f(0.0, -5.0);
glEnd();
glFlush();
}

int main(int argc, char **argv) {
  int win;
  glutInit(&argc, argv);
  glutInitWindowPosition(100, 100);
  glutInitWindowSize(500, 500);
  win = glutCreateWindow("Hyperbola");
  glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB);
  init();
  glutDisplayFunc(display);
  glutMainLoop();

 return 0;
}
