#include <gl/glut.h>
#include <math.h>

void draw_circ(int cx, int cy, float sweep_angle, float angle, float radius) {

  const int n = 500;
  float ang = sweep_angle * 3.14159265/180;
  float ang_inc = angle * 3.14159265/(180*n);
  int k;
  glBegin(GL_POINTS);
  for(k=1; k <= n; k++, ang+=ang_inc) 
    glVertex2f((GLfloat)cx+radius*cos(ang), (GLfloat)cy+radius*sin(ang));
  glEnd();

}
void draw_rect(int x, int y, int width, int height) {

  glBegin(GL_LINE_STRIP);
  glVertex2i(x, y);
  glVertex2i(x, y-height);
  glVertex2i(x+width, y-height);
  glVertex2i(x+width, y);
  glEnd();
}

void init(void) {

  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluOrtho2D(0.0, 100.0, 0.0, 100.0);
  glViewport(0, 0, 500, 500);
}

void draw_nand(int x, int y) {

  glBegin(GL_LINE_STRIP);
  glVertex2i(x+19, y);
  glVertex2i(x, y);
  glVertex2i(x, y-26);
  glVertex2i(x+19, y-26);
  glEnd();
  glFlush();

  glBegin(GL_LINES);
  glVertex2f(x, y-6.5);
  glVertex2f(x-10, y-6.5);
  glVertex2f(x, y-19.5);
  glVertex2f(x-10, y-19.5);
  glEnd();
  glFlush();

  draw_circ(x+19, y-13, 270.0, 180.0, 13.0);
  glFlush();
  draw_circ(x+34, y-13, 0.0, 360.0, 2.0);

}

void draw_nor(int x, int y) {

  int r = 26;
  draw_circ(x, y, 0.0, 30.0, 26.0);
  draw_circ(x, y, 330.0, 30.0, 26.0);
  glFlush();

  glBegin(GL_LINES);
  glVertex2f(x+22.36, y+13);
  glVertex2f(x+38.36, y+13);
  glVertex2f(x+22.36, y-13);
  glVertex2f(x+38.36, y-13);
  glVertex2f(x+25.11, y+6.72);
  glVertex2f(x+15.11, y+6.72);
  glVertex2f(x+25.11, y-6.72);
  glVertex2f(x+15.11, y-6.72);
  glEnd();
  glFlush();

  draw_circ(x+38.36, y-13, 30.0, 60.0, 26.0);
  draw_circ(x+38.36, y+13, 270.0, 60.0, 26.0);
  glFlush();

  draw_circ(x+62, y, 0.0, 360.0, 2.0);
  glFlush();

}

void display(void) {

  glClearColor(1.0, 1.0, 1.0, 1.0);
  glClear(GL_COLOR_BUFFER_BIT);
  glColor3f(0.0, 0.0, 0.0);

  draw_nand(22, 40);
  draw_nor(0, 60);

}

int main(int argc, char **argv) {
  int win;
  glutInit(&argc, argv);
  glutInitWindowPosition(100, 100);
  glutInitWindowSize(500, 500);
  win = glutCreateWindow("Logic Gates");
  glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB);
  init();
  glutDisplayFunc(display);
  glutMainLoop();

 return 0;
}
