#include "bonus.h"
#include <math.h>

Bonus :: Bonus() {

   setRadius(1);
   setColor(1.0,0.3,0.2);
   setVisible(true);
   rotAngle = 0;

}

bool Bonus :: getVisible() {
   return visible;
}

void Bonus :: setVisible(bool v) {
   visible = v;
}

void Bonus :: update(float dt) {
   rotAngle += 10 * dt;
}

void Bonus :: render() {

   Vec3d c = getColor();
   float r = getRadius();
   
   glColor3f(c.x,c.y,c.z);
   glTranslatef(position.x,sin(rotAngle/10)+position.y,position.z);
   glRotatef(rotAngle,1,1,1);
   glutSolidTorus(r/2,r,10,10);

}