/*
 * Lib3d Ornekleri -- 1
 *
 *
 * Konu:
 *    Arazi goruntuleme, animasyonlu model gosterme,
 *    tusa basilmalarin alinmasi ve model hareketinin saglanmasi
 *
 * Kullanilan Siniflar:
 *    Terrain, AnimatedModel, SimpleTimer, Camera, Vector3d
 *
 *
 *    :: Deniz Aydinoglu    :: 2002 ::
 *    :: www.oyunyapimi.org :: 2002 ::
 */

#include "init.h"
#include <lib3d/lib3d.h>
#include <lib3d/util/SimpleTimer.h>
#include <lib3d/terrain/Terrain.h>
#include <lib3d/util3d/Camera.h>
#include <lib3d/util3d/Vector3d.h>
#include <lib3d/model/AnimatedModel.h>
#include <lib3d/model/loader/MD2Loader.h>

#include <stdlib.h>
#include <time.h>

// bu degiskenler kesiksiz hareketin gerceklestirilmesi icin kullaniliyor..
bool          mov_north=false,mov_south=false,mov_west=false,mov_east=false;

// ana arazi nesnesi
Terrain       *terrain = NULL;

// animasyonlu model nesnesi
AnimatedModel *model   = NULL;

// ana kamera
Camera        cam;

// model pozisyonunu tutan vektor
Vector3d      pos(0,0,0);

// bilgisayar hizindan bagimsiz olarak (frame rate independent) hareketlerin
// gerceklestirilmesi isin kullanilan timer nesnesi
SimpleTimer   timer;

// model icerisindeki animasyonlar arasinda gecis yapmamizi saglayan degisken
int           frameNum = 0;


/*
 * Bu yordamda frame rate den bagimsiz bir bicimde karakterimizin
 * pozisyonu degistiriliyor (kesiksiz hareket)
 *
 * Yordam duzgun islemesi icin renderScene() icerisinden bir defa
 * cagirilmali.
 *
 */

void moveActor() {

   long dt = timer.timeElapsed();
   
   if (mov_north)
      pos.z -= 0.1 * dt;
   else
   if (mov_south)
      pos.z += 0.1 * dt;

   if (mov_west)
      pos.x -= 0.1 * dt;
   else
   if (mov_east)
      pos.x += 0.1 * dt;

}

/*
 * Bu yordam init.cpp deki SDL dongusunde devamli olarak cagiriliyor.
 * Icerisinde opengl cizim islemleri ve oyun mantigi geregi olan devamli
 * guncellemeler yapilabilir.
 *
 * Frame rate den bagimsiz islem yapilabilmesi icin tum hareketlenmelerin
 * (translate, rotate.. gibi) timer dan elde edilen elapsedTime() degeriyle
 * carpilarak uygulanmasina dikkat edilmeli.
 * Ayni zamanda renderScene() yordaminin son satirinda timer.update() birkez
 * cagirilmalidir.
 *
 */

void renderScene() {

   // bu yapinin kullanimi arazi uzerindeki yuksekligin hesaplanmasinda
   // bize hiz kazandirir.
   static PlaneEqCache cache;
   
   glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
   glLoadIdentity();

   // kamera bakis acisi ve konum bilgisine gore openGL matrisi
   // ayarlaniyor.. Bu satirlar ile kameramizdan bakmis oluyoruz..
   glRotatef(cam.xangle,1.0f,0.0f,0.0f);
   glRotatef((float)360.0-cam.yangle,0.0f,1.0f,0.0f);
   glTranslatef(-cam.pos.x,-cam.pos.y,-cam.pos.z);
   
   // arazi goruntuleniyor
   terrain->render();
   
   // Arazi uzerinde modelin bulundugu konuma gore yukseklik bilgisi
   // elde ediliyor. Cache hiz kazanmak icin kullanilmis(kullanilmasa da olurdu)
   // Daha sonra modelin konumu ayarlaniyor (arazi uzerine aliniyor), ve
   // bir miktar buyuklugu degistiriliyor. (devasa gozukmemesi icin), en sonun
   // da da goruntuleniyor (render)
   pos.y = terrain->getHeightOnTerrain(&pos,&cache);
   Vector3d bb = model->getAnimBoundingBox();
   glPushMatrix();
   glTranslatef(pos.x,pos.y,pos.z);
   glScalef(0.1,0.1,0.1);
   glTranslatef(0,bb.y/2,0);
   model->render();
   glPopMatrix();
   
   // model animasyonu burada saglaniyor (Frame rate den bagimsiz olarak)
   model->animate(timer.timeElapsed());
   moveActor();
   
   SDL_GL_SwapBuffers();
   timer.update();
}


/*
 * Bu yordam SDL tarfindan her tusa basilma durumunda cagirilir.
 * sym parametresi basilan tusun kodunu tasimaktadir.
 *
 */
void keyPressed(SDLKey sym) {

   switch (sym) {

      case SDLK_UP:
         mov_north = true;
         mov_south = false;
         break;

      case SDLK_DOWN:
         mov_north = false;
         mov_south = true;
         break;

      case SDLK_LEFT:
         mov_east = false;
         mov_west = true;
         break;

      case SDLK_RIGHT:
         mov_east = true;
         mov_west = false;
         break;

      case SDLK_SPACE:
         if (++frameNum == model->getAnimationCount())
            frameNum = 0;
         model->activeAnimation(frameNum);
         break;
   }

}

/*
 * Bu yordam SDL tarfindan tus birakilma durumunda cagirilir.
 * sym parametresi birakilan tusun kodunu tasimaktadir.
 *
 */
void keyReleased(SDLKey sym) {

   switch (sym) {

      case SDLK_UP:
         mov_north = false;
         break;

      case SDLK_DOWN:
         mov_south = false;
         break;

      case SDLK_LEFT:
         mov_west = false;
         break;

      case SDLK_RIGHT:
         mov_east = false;

   }

}

/*
 * Programin basinda bir kez otomatik olarak cagirilan rutin.
 *
 */

void initApp() {

   srand(time(NULL));
   
   terrain = new Terrain(64);
   terrain->setTexture("ttex.tga");
   terrain->generate(4,2,rand());
   terrain->setScale(1,0.3f,1);
   terrain->build();

   MD2Loader loader;
   model = loader.load("hobgoblin.md2","hobgoblin.tga");
   model->build();
   model->activeAnimation(frameNum);
   model->setSpeed(0.03f);
   model->setLooping(true);
   

   cam.moveBackward(50);
   cam.moveUp(30);
   cam.turnDown(30);

}

/*
 * Program biterken birkez cagirilan rutin..
 *
 */

void endApp() {

   if (model)   delete model;
   if (terrain) delete terrain;

}
