#include <lib3d/util3d/collision/CollisionDetector.h>

D3DVECTOR CollisionDetector :: getPosition(tMesh *mesh,D3DVECTOR position, D3DVECTOR velocity) {
	
 D3DVECTOR scaledPosition, scaledVelocity;	 
 D3DVECTOR finalPosition;

 // the first thing we do is scale the player and his velocity to
 // ellipsoid space
 scaledPosition = position; /// ellipsoidRadius;*/
 scaledVelocity = velocity; /// ellipsoidRadius;*/	
	
 // call the recursive collision response function	
 finalPosition = collideWithWorld(mesh,scaledPosition, scaledVelocity);
 	
 // when the function returns the result is still in ellipsoid space, so
 // we have to scale it back to R3 before we return it 	
 finalPosition = finalPosition;  //* ellipsoidRadius;
  
 return finalPosition; 	
	
}

D3DVECTOR getPositionOnTerrain(Terrain *t,D3DVECTOR position, D3DVECTOR velocity) {

   /*
   tMesh   mesh;
   tVertex vertices[3];
   tFace   face;

   face.v[0] = 0;
   face.v[1] = 1;
   face.v[2] = 2;
   vertices[0].
   */

   Vector3d v;
   return v;

}

D3DVECTOR CollisionDetector :: collideWithWorld(tMesh *mesh,D3DVECTOR position, D3DVECTOR velocity) {
 
  D3DVECTOR pos;
 
 
  // do we need to worry ?
  if (lengthOfVector(velocity) < EPSILON)
    return position;
   	
 	
  D3DVECTOR destinationPoint(position.x+velocity.x,position.y+velocity.y,position.z+velocity.z);
 
  tCollisionPacket collision;
  collision.velocity = velocity;
  collision.sourcePoint = position;
  collision.foundCollision = FALSE;
  collision.stuck = FALSE;
  collision.nearestDistance = -1;	
   
  
  // check for a collision with mesh
  checkCollision(mesh,&collision);   	
    
  // check return value here, and possibly call recursively 	
	
  if (collision.foundCollision == FALSE)
   { 
     // if no collision move very close to the desired destination. 
     float l = lengthOfVector(velocity);
     D3DVECTOR V = velocity; 
     setLength(V, l-EPSILON);
     	
     // update the last safe position for future error recovery	
     collision.lastSafePosition = position;      
     
     // return the final position
     position.add(&V);
     return position;
   }
  else { // There was a collision
   
    
    // If we are stuck, we just back up to last safe position
    if (collision.stuck) {
      return collision.lastSafePosition;
    
    
      
    // OK, first task is to move close to where we hit something :
    D3DVECTOR newSourcePoint;
                   
    // only update if we are not already very close
    if (collision.nearestDistance >= EPSILON) {
         
      D3DVECTOR V = velocity;
      setLength(V, collision.nearestDistance-EPSILON);
      newSourcePoint.set(collision.sourcePoint.x+V.x,collision.sourcePoint.y+V.y,collision.sourcePoint.z+V.z);
    }
    else
      newSourcePoint = collision.sourcePoint;

   

    // Now we must calculate the sliding plane
    D3DVECTOR slidePlaneOrigin = collision.nearestPolygonIntersectionPoint;
    D3DVECTOR slidePlaneNormal(newSourcePoint.x-collision.nearestPolygonIntersectionPoint.x,
                               newSourcePoint.y-collision.nearestPolygonIntersectionPoint.y,
                               newSourcePoint.z-collision.nearestPolygonIntersectionPoint.z);
  
      
    // We now project the destination point onto the sliding plane
    double l = intersectRayPlane(destinationPoint, slidePlaneNormal, 
                                 slidePlaneOrigin, slidePlaneNormal); 
    
  
    // We can now calculate a new destination point on the sliding plane
    D3DVECTOR newDestinationPoint;
    newDestinationPoint.x = destinationPoint.x + l * slidePlaneNormal.x;
    newDestinationPoint.y = destinationPoint.y + l * slidePlaneNormal.y;
    newDestinationPoint.z = destinationPoint.z + l * slidePlaneNormal.z;
   
    
    // Generate the slide vector, which will become our new velocity vector
    // for the next iteration
    D3DVECTOR newVelocityVector(newDestinationPoint.x-collision.nearestPolygonIntersectionPoint.x,
                                newDestinationPoint.y-collision.nearestPolygonIntersectionPoint.y,
                                newDestinationPoint.z-collision.nearestPolygonIntersectionPoint.z);
        
       
    // now we recursively call the function with the new position and velocity 
    collision.lastSafePosition = position;
    return collideWithWorld(mesh,newSourcePoint, newVelocityVector); 
    
  }
 
 }
}

void CollisionDetector :: checkCollision(tMesh *mesh,tCollisionPacket* colPackage) {

 // plane data
 int A, B, C;
 D3DVECTOR p1,p2,p3;
 D3DVECTOR pNormal;
 D3DVECTOR pOrigin;
 D3DVECTOR v1, v2;
 
 // from package
 D3DVECTOR source = colPackage->sourcePoint;
 D3DVECTOR eRadius = colPackage->eRadius;
 D3DVECTOR velocity = colPackage->velocity;	
 
 // keep a copy of this as it's needed a few times
 D3DVECTOR normalizedVelocity = velocity;
 normalizeVector(normalizedVelocity);
 
 // intersection data
 D3DVECTOR sIPoint;    // sphere intersection point
 D3DVECTOR pIPoint;    // plane intersection point 	
 D3DVECTOR polyIPoint; // polygon intersection point
 
 // how long is our velocity
 double distanceToTravel = lengthOfVector(velocity);	
 
 double distToPlaneIntersection;
 double distToEllipsoidIntersection;
  
 // loop through all faces in mesh  	
 for (int i=0; i<mesh->faceCount; i++)
  {
               
     A = mesh->faces[i].v[0];
     B = mesh->faces[i].v[1];
     C = mesh->faces[i].v[2];
     
     // Get the data for the triangle in question and scale to ellipsoid space
     p1.x = mesh->vertices[A].x / eRadius.x;
     p1.y = mesh->vertices[A].y / eRadius.y;
     p1.z = mesh->vertices[A].z / eRadius.z;
         
     p2.x = mesh->vertices[B].x / eRadius.x;
     p2.y = mesh->vertices[B].y / eRadius.y;
     p2.z = mesh->vertices[B].z / eRadius.z;
             
     p3.x = mesh->vertices[C].x / eRadius.x;
     p3.y = mesh->vertices[C].y / eRadius.y;
     p3.z = mesh->vertices[C].z / eRadius.z;
               
               
     // Make the plane containing this triangle.      
     pOrigin = p1;
     v1.set(p2.x-p1.x,p2.y-p1.y,p2.z-p1.z);
     v2.set(p3.x-p1.x,p3.y-p1.y,p3.z-p1.z);
    
        
     // You might not need this if you KNOW all your triangles are valid
     if (!(isZeroVector(v1) || isZeroVector(v2))) {
                         
     	// determine normal to plane containing polygon  
     	pNormal = wedge(v1, v2);
     	normalizeVector(pNormal);
     
    
        //ignore backfaces. What we cannot see we cannot collide with ;)
	if (dot(pNormal, normalizedVelocity) <= 1.0f) { 
    
     		// calculate sphere intersection point
     		sIPoint.set(source.x - pNormal.x,source.y - pNormal.y,source.z - pNormal.z);
        
     		// classify point to determine if ellipsoid span the plane
     		DWORD pClass = classifyPoint(sIPoint, pOrigin, pNormal);
         
     
     		// find the plane intersection point
     		if (pClass == PLANE_BACKSIDE) { // plane is embedded in ellipsoid
     
      			// find plane intersection point by shooting a ray from the 
      			// sphere intersection point along the planes normal.
      			distToPlaneIntersection = intersectRayPlane(sIPoint, pNormal, pOrigin, pNormal);
                       
      			// calculate plane intersection point
      			pIPoint.x = sIPoint.x + distToPlaneIntersection * pNormal.x; 
      			pIPoint.y = sIPoint.y + distToPlaneIntersection * pNormal.y; 
      			pIPoint.z = sIPoint.z + distToPlaneIntersection * pNormal.z; 	
       
     		} 
     		else { 
     
     			// shoot ray along the velocity vector
     			distToPlaneIntersection = intersectRayPlane(sIPoint, normalizedVelocity, pOrigin, pNormal);
               
     			// calculate plane intersection point
     			pIPoint.x = sIPoint.x + distToPlaneIntersection * normalizedVelocity.x; 
     			pIPoint.y = sIPoint.y + distToPlaneIntersection * normalizedVelocity.y; 
     			pIPoint.z = sIPoint.z + distToPlaneIntersection * normalizedVelocity.z; 	
          	
     		}
     
       
     
     		// find polygon intersection point. By default we assume its equal to the 
     		// plane intersection point
     
     		polyIPoint = pIPoint;
     		distToEllipsoidIntersection = distToPlaneIntersection;
     
     		if (!CheckPointInTriangle(pIPoint,p1,p2,p3)) { // if not in triangle
     	
      			polyIPoint = closestPointOnTriangle(p1, p2, p3, pIPoint);	
           
      			normalizedVelocity.invert();
               
               distToEllipsoidIntersection = intersectRaySphere(polyIPoint, normalizedVelocity, source, 1.0f);
                  
      			if (distToEllipsoidIntersection > 0) { 	
     			// calculate true sphere intersection point
     				sIPoint.x = polyIPoint.x + distToEllipsoidIntersection * normalizedVelocity.x;
     				sIPoint.y = polyIPoint.y + distToEllipsoidIntersection * normalizedVelocity.y;
     				sIPoint.z = polyIPoint.z + distToEllipsoidIntersection * normalizedVelocity.z;
     			}
    
     		} 
     
    
  		// Here we do the error checking to see if we got ourself stuck last frame
   		if (CheckPointInSphere(polyIPoint, source, 1.0f)) 
			colPackage->stuck = TRUE;
       
    
		// Ok, now we might update the collision data if we hit something
    		if ((distToEllipsoidIntersection > 0) && (distToEllipsoidIntersection <= distanceToTravel)) { 
     			if ((colPackage->foundCollision == FALSE) || (distToEllipsoidIntersection < colPackage->nearestDistance))  {
           
                		// if we are hit we have a closest hit so far. We save the information
      				colPackage->nearestDistance = distToEllipsoidIntersection;
      		       		colPackage->nearestIntersectionPoint = sIPoint;
      				colPackage->nearestPolygonIntersectionPoint = polyIPoint;
      				colPackage->foundCollision = TRUE;
			}
    		} 
           
	} // if not backface
   } // if a valid plane 	
 } // for all faces	
}