#include <lib3d/util2d/Texture.h>

#include <math.h>
#define  M_PI   3.14159265358979323846

Texture :: Texture(char *path) {
   strcpy(this->path,path);
   enableMipmapping(true);
   stageCount = 0;
   stages = NULL;

   if (strcmp(strchr(this->path,'.'),".shader") == 0) {
      useShaders = true;
   }
   else
      useShaders = false;

   setWrapS(GL_REPEAT);
   setWrapT(GL_REPEAT);

}

Texture :: ~Texture() {
}

bool Texture :: isExists() {

   FILE *fp = fopen(path,"r");
   if (fp != NULL){
      fclose(fp);
      return true;
   }
   return false;

}

void Texture :: enableMipmapping(bool b) {
   useMipMaps = b;
}

void Texture :: setWrapS(int ws) {
   wrapS = ws;
}

void Texture :: setWrapT(int wt) {
   wrapT = wt;
}

// Eski rutin.. (SDL kullanarak yanlizca BMP yukuluyor(du).. )
/*
bool Texture :: build() {

   
   SDL_Surface *image1;
    
   image1 = loadBMP(path);
   if (!image1) {
      return false;
   }

   // Create Texture	
   unsigned int t[1];
   glGenTextures(1, t);
   id = t[0];
   glBindTexture(GL_TEXTURE_2D, id);   // 2d texture (x and y size)

   glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
   
   if (useMipMaps) {
      glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR_MIPMAP_NEAREST);
      gluBuild2DMipmaps(GL_TEXTURE_2D,GL_RGB,image1->w,image1->h,GL_RGB,GL_UNSIGNED_BYTE,image1->pixels);   
   }
   else {
      glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
      glTexImage2D(GL_TEXTURE_2D, 0, 3, image1->w, image1->h, 0, GL_RGB, GL_UNSIGNED_BYTE, image1->pixels);
   }
       
   SDL_FreeSurface(image1);

   return true;
}
*/

// Yeni rutin (Nate Miller in tga lib ini kullanarak Uncompressed TGA yukluyor...)
// Yada useShaders=true ise shader yukleniyor...
bool Texture :: build() {

   if (useShaders)
      return build_shaders();
   
   glTga_t img;
   img.GenId(1,&id);

   if (useMipMaps) {
      img.SetMipMap(1);
      img.SetMinFilter(GL_LINEAR_MIPMAP_NEAREST);
   }

   img.SetWrapS(wrapS);
   img.SetWrapT(wrapT);

   if (img.Load(path,id) == 1) {
      img.Upload(1);
      return true;
   }

   return false;
}

void Texture :: makeCurrent() {
   glEnable(GL_TEXTURE_2D);
   glBindTexture(GL_TEXTURE_2D,id);
}

void Texture :: begin() {
   
   register int i;
   float dt;

   if (!useShaders) {
      makeCurrent();
      return;
   }

   dt = shaderTimer.timeElapsed() / 1000.0f;

   for (i=0;i<stageCount;++i) {
      
      glActiveTextureARB(GL_TEXTURE0_ARB+i);
      glEnable(GL_TEXTURE_2D);

      if (stages[i].anim) {
         stages[i].anim_curr_frame_time += dt;
         if (stages[i].anim_curr_frame_time >= stages[i].anim_frame_secs) {
            if (++stages[i].anim_curr_frame >= stages[i].anim_frame_count)
               stages[i].anim_curr_frame = 0;
            stages[i].anim_curr_frame_time = 0;
         }
         glBindTexture(GL_TEXTURE_2D,stages[i].anim_textures[stages[i].anim_curr_frame]->getId());
      }
      else
         glBindTexture(GL_TEXTURE_2D,stages[i].texture->getId());
     
      glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, stages[i].tex_env_mode);
      glMatrixMode(GL_TEXTURE);
      glLoadIdentity();

      if (stages[i].detail) {
         glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_COMBINE_EXT);
         glTexEnvi(GL_TEXTURE_ENV, GL_RGB_SCALE_EXT, 2);
         glScalef(stages[i].detail_scale,stages[i].detail_scale,1);
      }
         
      if (stages[i].scroll) {
         stages[i].scroll_s_curr += stages[i].scroll_s * dt;
         stages[i].scroll_t_curr += stages[i].scroll_t * dt;
         glTranslatef(stages[i].scroll_s_curr,stages[i].scroll_t_curr,0);
      }
         
      if (stages[i].rotate) {
         glTranslatef(0.5,0.5,0);
         stages[i].rot_degree += stages[i].rot_speed * dt;
         glRotatef(stages[i].rot_degree,0,0,1);
         glTranslatef(-0.5,-0.5,0);
      }
                  
      if (stages[i].scale_sin) {
         stages[i].scale_sin_deg += 2*M_PI*dt/stages[i].scale_sin_period;
         float val = stages[i].scale_sin_base + stages[i].scale_sin_amp * sin(stages[i].scale_sin_deg);
         glTranslatef(0.5,0.5,0);
         glScalef(val,val,1);
         glTranslatef(-0.5,-0.5,0);
      }
          
      if (stages[i].rgb_sin) {
         stages[i].rgb_sin_deg += 2*M_PI*dt/stages[i].rgb_sin_period;
         float val = stages[i].rgb_sin_base + stages[i].rgb_sin_amp * sin(stages[i].rgb_sin_deg);
         glColor3f(val,val,val);
      }

      if (stages[i].envmapping) {
         glTexGeni(GL_S, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);
         glTexGeni(GL_T, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);
         glEnable(GL_TEXTURE_GEN_S);
         glEnable(GL_TEXTURE_GEN_T);
      }
      else {
         glDisable(GL_TEXTURE_GEN_S);
         glDisable(GL_TEXTURE_GEN_T);
      }
      
      glMatrixMode(GL_MODELVIEW);

   }


}

void Texture :: end() {
   
   register int i;
   
   if (useShaders) {
   
      for(i=0;i<stageCount;++i) {
         glActiveTextureARB(GL_TEXTURE0_ARB+i);
         glDisable(GL_TEXTURE_2D);
      }

      shaderTimer.update();
   }

}

void Texture :: apply(float u,float v) {

   register int i;
   
   if (!useShaders) {
      glTexCoord2f(u,v);
   }
   else {
      for(i=0;i<stageCount;++i)
         glMultiTexCoord2fARB(GL_TEXTURE0_ARB+i,u,v);
   }

}

unsigned int Texture :: getId() {
   return id;
}

void Texture :: render() {

   begin();      

   glBegin(GL_QUADS);
            
      apply(1,0);
      glVertex2d(-1,-1);
            
      apply(0,0);
      glVertex2d( 1,-1);
            
      apply(0,1);
      glVertex2d( 1, 1);
            
      apply(1,1);
      glVertex2d(-1, 1);

   glEnd();

   end();
}

bool Texture :: build_shaders() {
   stages = ShaderLoader::load(path,&stageCount);
   return (stages != NULL);
}

// Eski build() rutini kullaniyor(du)...
SDL_Surface* Texture :: loadBMP(char *filename) {
    
   Uint8 *rowhi, *rowlo;
   Uint8 *tmpbuf, tmpch;
   SDL_Surface *image;
   int i, j;

   image = SDL_LoadBMP(filename);
   if ( image == NULL ) {
       fprintf(stderr, "Unable to load %s: %s\n", filename, SDL_GetError());
       return(NULL);
   }

   /* GL surfaces are upsidedown and RGB, not BGR :-) */
   tmpbuf = (Uint8 *)malloc(image->pitch);
   if ( tmpbuf == NULL ) {
       fprintf(stderr, "Out of memory\n");
       return(NULL);
   }
   rowhi = (Uint8 *)image->pixels;
   rowlo = rowhi + (image->h * image->pitch) - image->pitch;
   for ( i=0; i<image->h/2; ++i ) {
       for ( j=0; j<image->w; ++j ) {
           tmpch = rowhi[j*3];
           rowhi[j*3] = rowhi[j*3+2];
           rowhi[j*3+2] = tmpch;
           tmpch = rowlo[j*3];
           rowlo[j*3] = rowlo[j*3+2];
           rowlo[j*3+2] = tmpch;
       }
       memcpy(tmpbuf, rowhi, image->pitch);
       memcpy(rowhi, rowlo, image->pitch);
       memcpy(rowlo, tmpbuf, image->pitch);
       rowhi += image->pitch;
       rowlo -= image->pitch;
   }
   free(tmpbuf);
   return(image);
}
 
