#include <lib3d/util2d/shaders/ShaderLoader.h>

Stage* ShaderLoader :: load(char *path,int *stageCount) {
   
   char key[MAX_KEY_LEN], val[MAX_VALUE_LEN];
   PropReader pr(path);
   
   *stageCount = pr.getInt("stages");
   Stage *stages = new Stage[*stageCount];

   for (int i=0;i<*stageCount;++i) {
     
      sprintf(key,"texture_%d",i);
      pr.getString(key,val);
      if (strcmp(val,"") != 0)
         stages[i].texture = new Texture(val);

      sprintf(key,"tex_env_mode_%d",i);
      pr.getString(key,val);
      if (strcmp(val,"GL_DECAL") == 0)
         stages[i].tex_env_mode = GL_DECAL;
      else
      if (strcmp(val,"GL_REPLACE") == 0)
         stages[i].tex_env_mode = GL_REPLACE;
      else
      if (strcmp(val,"GL_ADD") == 0)
         stages[i].tex_env_mode = GL_ADD;
      else
      if (strcmp(val,"GL_MODULATE") == 0)
         stages[i].tex_env_mode = GL_MODULATE;

      sprintf(key,"envmapping_%d",i);
      pr.getString(key,val);
      if (strcmp(val,"true") == 0)
         stages[i].envmapping = true;
      
      sprintf(key,"detail_%d",i);
      pr.getString(key,val);
      if (strcmp(val,"true") == 0)
         stages[i].detail = true;
      
      sprintf(key,"detail_scale_%d",i);
      stages[i].detail_scale = pr.getInt(key);
      
      sprintf(key,"rotate_%d",i);
      pr.getString(key,val);
      if (strcmp(val,"true") == 0) {
         stages[i].rotate = true;
         sprintf(key,"rot_speed_%d",i);
         stages[i].rot_speed = pr.getFloat(key);
      }

      sprintf(key,"scroll_%d",i);
      pr.getString(key,val);
      if (strcmp(val,"true") == 0) {
         stages[i].scroll = true;
         sprintf(key,"scroll_s_%d",i);
         stages[i].scroll_s = pr.getFloat(key);
         sprintf(key,"scroll_t_%d",i);
         stages[i].scroll_t = pr.getFloat(key);
      }

      sprintf(key,"scale_sin_%d",i);
      pr.getString(key,val);
      if (strcmp(val,"true") == 0) {
         stages[i].scale_sin = true;
         sprintf(key,"scale_sin_base_%d",i);
         stages[i].scale_sin_base = pr.getFloat(key);
         sprintf(key,"scale_sin_amp_%d",i);
         stages[i].scale_sin_amp = pr.getFloat(key);
         sprintf(key,"scale_sin_period_%d",i);
         stages[i].scale_sin_period = pr.getFloat(key);
         stages[i].texture->setWrapS(GL_CLAMP);
         stages[i].texture->setWrapT(GL_CLAMP);
      }           

      sprintf(key,"rgb_sin_%d",i);
      pr.getString(key,val);
      if (strcmp(val,"true") == 0) {
         stages[i].rgb_sin = true;
         sprintf(key,"rgb_sin_base_%d",i);
         stages[i].rgb_sin_base = pr.getFloat(key);
         sprintf(key,"rgb_sin_amp_%d",i);
         stages[i].rgb_sin_amp = pr.getFloat(key);
         sprintf(key,"rgb_sin_period_%d",i);
         stages[i].rgb_sin_period = pr.getFloat(key);
      }           

      sprintf(key,"anim_%d",i);
      pr.getString(key,val);
      if (strcmp(val,"true") == 0) {
         stages[i].anim = true;
         sprintf(key,"anim_frame_secs_%d",i);
         stages[i].anim_frame_secs = pr.getFloat(key);
         sprintf(key,"anim_frame_count_%d",i);
         stages[i].anim_frame_count = pr.getInt(key);
         if (stages[i].anim_frame_count > MAX_ANIM_FRAMES)
            stages[i].anim_frame_count = MAX_ANIM_FRAMES;
         for (int f=0;f<stages[i].anim_frame_count;++f) {
            sprintf(key,"anim_frame_%d_%d",f,i);
            pr.getString(key,val);
            stages[i].anim_textures[f] = new Texture(val);
            stages[i].anim_textures[f]->build();
         }
      }

      
      if (stages[i].texture)
         stages[i].texture->build();


   }
   
   return stages;
}

