#include <lib3d/model/loader/MSAsciiLoader.h>
#include <vector>

using namespace std;

MSAsciiLoader :: MSAsciiLoader() {
}

MSAsciiLoader :: ~MSAsciiLoader() {
}

Model* MSAsciiLoader :: load(char *path) {

   fp = fopen(path,"rt");
   if (fp == NULL)
      return NULL;
   
   // Frames: x
   skipLine();               
   // Frame: y
   skipLine();

   Model *model = new Model();
   tMesh *meshes;
   tMaterial *materials;
   
   int meshCount = readMeshCount();
   meshes = new tMesh[meshCount];
   model->setMeshes(meshes,meshCount);

   for (int m=0;m<meshCount;++m) {

      // "mesh_name" x y
      char meshName_unused[256];
      meshes[m].materialIndex = readMeshName_materialIndex(meshName_unused);

      meshes[m].vertexCount = readInt();
      meshes[m].vertices = new tVertex[meshes[m].vertexCount];

      meshes[m].uvCount = meshes[m].vertexCount;
      meshes[m].uvs = new tUV[meshes[m].uvCount];
      
      float maxx=-100000,maxy=-100000,maxz=-100000;
      float minx=100000,miny=100000,minz=100000;
      
      for (int v=0;v<meshes[m].vertexCount;++v) {

         tVertexData vd;
         readVertexData(&vd);
         meshes[m].vertices[v].x = vd.x;
         meshes[m].vertices[v].y = vd.y;
         meshes[m].vertices[v].z = vd.z;
         meshes[m].uvs[v].u = vd.u;
         meshes[m].uvs[v].v = 1 - vd.v;           //HACK!!!!!!

         // BoundingBox calculation for mesh
         if (maxx < meshes[m].vertices[v].x) maxx = meshes[m].vertices[v].x;
         if (maxy < meshes[m].vertices[v].y) maxy = meshes[m].vertices[v].y;
         if (maxz < meshes[m].vertices[v].z) maxz = meshes[m].vertices[v].z;
         if (minx > meshes[m].vertices[v].x) minx = meshes[m].vertices[v].x;
         if (miny > meshes[m].vertices[v].y) miny = meshes[m].vertices[v].y;
         if (minz > meshes[m].vertices[v].z) minz = meshes[m].vertices[v].z;

      }

      meshes[m].boundingBox.set(maxx-minx,maxy-miny,maxz-minz);
 
      meshes[m].normalCount = readInt();
      meshes[m].normals = new Vector3d[meshes[m].normalCount];

      for (int n=0;n<meshes[m].normalCount;++n) {
      
         tNormalData nd;
         readNormalData(&nd);
         meshes[m].normals[n].set(nd.x,nd.y,nd.z);
      
      }

      meshes[m].faceCount = readInt();
      meshes[m].faces = new tFace[meshes[m].faceCount];
            
      for (int f=0;f<meshes[m].faceCount;++f) {
      
         tFaceData fd;
         readFaceData(&fd);
         meshes[m].faces[f].v[0] = fd.v1;
         meshes[m].faces[f].v[1] = fd.v2;
         meshes[m].faces[f].v[2] = fd.v3;
         meshes[m].faces[f].n[0] = fd.n1;
         meshes[m].faces[f].n[1] = fd.n2;
         meshes[m].faces[f].n[2] = fd.n3;

         meshes[m].faces[f].uv[0] = fd.v1;
         meshes[m].faces[f].uv[1] = fd.v2;
         meshes[m].faces[f].uv[2] = fd.v3;
      
      }

   }

   int materialCount = readMaterialCount();
   materials = new tMaterial[materialCount];
   model->setMaterials(materials,materialCount);

   for (m=0;m<materialCount;++m) {
      
      // "material_name"
      skipLine();

      tMatProp mp;
      readMaterialProperty(&mp);
      materials[m].ambient.set(&mp.amb);
      materials[m].diffuse.set(&mp.dif);
      materials[m].emissive.set(&mp.emi);
      materials[m].specular.set(&mp.spe);
      materials[m].shininess = 0;
      materials[m].transparency = 0;
      strlen(mp.texName1)!=0 ? materials[m].texture = new Texture(mp.texName1)
                              : materials[m].texture = NULL;
      
   }


   fclose(fp);
   return model;
}

void MSAsciiLoader :: skipLine() {
   char tmp[256];
   readLine(tmp);
}

int MSAsciiLoader :: readMeshCount() {
   
   char line[256];
   int meshCount;

   readLine(line);
   sscanf(line,"Meshes: %d",&meshCount);

   return meshCount;
}

int MSAsciiLoader :: readMaterialCount() {
   
   char line[256];
   int matCount;

   readLine(line);
   sscanf(line,"Materials: %d",&matCount);

   return matCount;
}

int MSAsciiLoader :: readInt() {

   char line[256];
   int num;

   readLine(line);
   sscanf(line,"%d",&num);

   return num;
}

float MSAsciiLoader :: readFloat() {

   char line[256];
   float num;

   readLine(line);
   sscanf(line,"%f",&num);

   return num;
}

void MSAsciiLoader :: readVertexData(tVertexData *vd) {

   char line[256];
   int  flags,boneId;     // unused ,yet.

   readLine(line);
   sscanf(line,"%d %f %f %f %f %f %d",&flags,&vd->x,&vd->y,&vd->z,&vd->u,&vd->v,&boneId);

}

void MSAsciiLoader :: readNormalData(tNormalData *nd) {

   char line[256];
   readLine(line);
   sscanf(line,"%f %f %f",&nd->x,&nd->y,&nd->z);

}

void MSAsciiLoader :: readFaceData(tFaceData *fd) {

   char line[256];
   int  flags,smoothingGroup;       // unused, yet.

   readLine(line);
   sscanf(line,"%d %d %d %d %d %d %d %d",&flags,&fd->v1,&fd->v2,&fd->v3,
                                             &fd->n1,&fd->n2,&fd->n3,&smoothingGroup);

}

void MSAsciiLoader :: readMaterialProperty(tMatProp *mp) {

   char line[256];
   float r,g,b,a;
   
   readLine(line);
   sscanf(line,"%f %f %f %f",&r,&g,&b,&a);
   mp->amb.set(r,g,b,a);

   readLine(line);
   sscanf(line,"%f %f %f %f",&r,&g,&b,&a);
   mp->dif.set(r,g,b,a);

   readLine(line);
   sscanf(line,"%f %f %f %f",&r,&g,&b,&a);
   mp->spe.set(r,g,b,a);

   readLine(line);
   sscanf(line,"%f %f %f %f",&r,&g,&b,&a);
   mp->emi.set(r,g,b,a);

   mp->var1 = readFloat();
   mp->var2 = readFloat();

   readString(mp->texName1);
   readString(mp->texName2);

}

void MSAsciiLoader :: readString(char *str) {

   char tmp[256];
   
   readLine(tmp);
   strcpy(str,tmp+1);
   char *ptr = strrchr(str,'"');
   *ptr = '\0';
   
}

int MSAsciiLoader :: readMeshName_materialIndex(char *meshName) {

   char line[256], name[256], tmp[256];
   int unknown, index;

   readLine(line);
   sscanf(line,"%s %d %d",tmp,&unknown,&index);
   strcpy(name,tmp+1);
   name[strlen(name)-1] = '\0';

   return index;

}

void MSAsciiLoader :: readLine(char *line) {

   // bos satirlari ve aciklama satirlarini atla... (// ile baslayanlar aciklamadir..)
   // ilk bulunann satiri line icinde geri getir..

   while (fgets(line,255,fp) != NULL && 
      (strlen(line) == 1 || (line[0] == '/' && line[1] == '/')));

}

