#ifndef __MD2LOADER_H__
#define __MD2LOADER_H__

#pragma warning (disable : 4786)

#include <stdio.h>
#include <string.h>
#include <vector>
using namespace std;

#include <lib3d/model/loader/md2defs.h>
#include <lib3d/model/animatedmodel.h>


class MD2Loader {

public:

   MD2Loader();
   ~MD2Loader();

   AnimatedModel* load(char *path,char *strTexture);

private:

   void buildModelFromMD2Data(AnimatedModel *model);
   void calculateAndStoreAnimations(AnimatedModel *model);
   void cleanUp();
   
   tMd2Header      m_Header;			// The header data
   tMd2Skin       *m_pSkins;			// The skin data
   tMd2TexCoord   *m_pTexCoords;		// The texture coordinates
   tMd2Face       *m_pTriangles;		// Face index information
   tMd2Frame      *m_pFrames;			// The frames of animation (vertices)

   FILE *fp;


};


#endif