#ifndef __VECTOR3D__H__
#define __VECTOR3D__H__

#include <stdio.h>
#include <math.h>

class Vector3d {

public:
   
   Vector3d() {};
   Vector3d(float x,float y,float z);
   Vector3d(int x,int y,int z);
   ~Vector3d() {};

   void  normalize();
   void  zero();
   float length() const;
   bool  equals(const Vector3d *v) const;
   void  invert();
   void  set(float x,float y,float z);
   void  set(const Vector3d *v);
   void  scale(const Vector3d *s);
   void  scale(float sx,float sy,float sz);
   float dot(const Vector3d *v);
   void  cross(const Vector3d *v);
   void  add(const Vector3d *v);
   void  add(float x,float y,float z);
   void  sub(const Vector3d *v);
   void  sub(float x,float y,float z);
   void  print(FILE *fp) const;
   Vector3d* clone() const;
   
   static float dot(const Vector3d *v1,const Vector3d *v2);
   static Vector3d cross(const Vector3d *v1,const Vector3d *v2);

   float  x,y,z;

};


#endif