#ifndef __POSITION3D__H__
#define __POSITION3D__H__

#include <lib3d/util3d/vector3d.h>

class Position3d {

public:

   Position3d();
   Position3d(Vector3d *pos,float xa,float ya,float za);
   ~Position3d();

   void set(const Position3d *pos3d);
   Vector3d* getDirection() const;
   void lookAt(float x,float y,float z);
   void turnLeft(float angle);
   void turnRight(float angle);
   void turnUp(float angle);
   void turnDown(float angle);
   void strafeLeft(float dist);
   void strafeRight(float dist);
   void moveUp(float dist);
   void moveDown(float dist);
   void moveForward(float dist);
   void moveBackward(float dist);
   Position3d clone() const;

   Vector3d pos;
   float xangle,yangle,zangle;

};

#endif