#ifndef __STAGE_H__
#define __STAGE_H__

#pragma warning (disable : 4786)

#ifdef WIN32
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#endif

#include <gl/gl.h>
#include <lib3d/util2d/Texture.h>

#define MAX_ANIM_FRAMES 16

class Texture;

class Stage {

public:

   Stage();
   ~Stage();

   Texture *texture;
   GLuint  tex_env_mode;

   bool envmapping;
   
   bool  detail;
   int   detail_scale;
   
   bool  rotate;
   float rot_speed;
   float rot_degree;      // internal variable..
   
   bool  scale_sin;
   float scale_sin_period;
   float scale_sin_base;
   float scale_sin_amp;
   float scale_sin_deg;       // internal
   
   bool  scroll;
   float scroll_s;
   float scroll_t;
   float scroll_s_curr;       // internal
   float scroll_t_curr;       // internal
   
   bool  rgb_sin;
   float rgb_sin_period;
   float rgb_sin_base;
   float rgb_sin_amp;
   float rgb_sin_deg;       // internal

   bool  anim;
   int   anim_frame_count;
   float anim_frame_secs;
   Texture *anim_textures[MAX_ANIM_FRAMES];
   int   anim_curr_frame;        // internal
   float anim_curr_frame_time;   // internal

};


#endif