// **********************************************************************
//
// GLUI  - opengl icin grafiksel kullanici arayuzu kutuphanesi
//
// Ornek-2
//
// Deniz Aydinoglu :: 2004 :: www.oyunyapimi.org
//
//
// ********** GLUI Ornek 2 **************************************
//
// GLUI Ornek 1 dokumanini okumamis olanlara bu dokumandan once diger
// dokumana bir goz atmalarini oneriyorum. Ornek2 , ornek1 deki kod yapisini
// aynen kullanip uzerine eklemeler yapiyor.
//
// GLUI Ornek 2 de , Panel,CheckBox ve ListBox widget larini kullanmayi ogrenip
// ayni zamanda "LiveVarible" olarak adlandirilan yararli GLUI ozelliginin
// kullanimini ornekleyecegiz.

// GLUI yi kullanmak icin tek include etmemiz gereken header dosyasi glui.h
#include "glui.h"

// GLUI de gorsel bilesenleri widget olarak adlandiriyoruz. Butonlar, textbox lar,
// Label lar ve bunun gibi tum gorsel bilesenler widget tir.
// Asagida kullanacagimiz her 3 button widget ini belirtmek icin bir integer tam sayi
// tanimliyoruz. GLUI sistemi widget larimizi bu sayilar ile taniyacak.
enum eWidgetId { WIDGET_BUTTON_RED=0, WIDGET_BUTTON_GREEN, WIDGET_BUTTON_BLUE };

// Kullaniciya secme hakki tanidigimiz cisimler icin bir enumeration olusturuyoruz.
// displayCB() icerisinde secilen cismin koduna gore o cisimi cizdirecegiz.
enum eObjectType { OT_CUBE=0, OT_SPHERE, OT_TORUS, OT_TEAPOT };

// bu degisken ana glui pencerimizi belirtecek.
static int main_window;

// ana glui pencere nesnesi.. widget yaratmak icin bu nesnenin fonksiyonlarini cagiracagiz.
static GLUI *glui;

// bu degiskenler ornegimizde donup duran cismin rengini belirtiyorlar.
// ilk basta cisim rengi beyaz..
float color_red   = 1.0f;
float color_green = 1.0f;
float color_blue  = 1.0f;

// bu degisken ListBox icinde secilmis olan elemanin belirtiyor.
// GLUI sistemi ListBox icinde bir eleman secildigi zaman otomatik olarak bu degiskenin
// degerini gunleyecektir. Bu ozellik "Live Variable" olarak adlandiriliyor.
int selected_object;

// Bu degiskenler ilgili seceneklerin checkbox lar tarafindan secili olup olmadigi bilgisine sahip (1 yada 0)
// Yine LiveVariable ozelligi kullanilmis.
int wire_frame_selected;
int use_lighting_selected;

// klasik glut idle callback yordami..
void idleCB( void ) {

   // bu tanimi yapmamiz glui programlarimizin duzgun islemesi icin gerekli.
   if ( glutGetWindow() != main_window ) 
     glutSetWindow(main_window);  

   // idle icerisinde glut un goruntuyu tazelemesini istiyoruz..
   // yani displayCB yordami dolayli olarak cagiriliyor.
   glutPostRedisplay();
}

// klasik glut reshape callback yordami
// bu yordam her pencere boyutu degistiginde cagiriliyor.
// ayrica her program baslangicinda bir defaya mahsus olarakta cagirilmakta.
void reshapeCB( int x, int y ) {
  
   float xy_aspect;

   xy_aspect = (float)x / (float)y;
   glViewport(0,0,x,y);

   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   gluPerspective(50.0f,xy_aspect,0.1f,1000.0f);

   glMatrixMode(GL_MODELVIEW);
   glutPostRedisplay();
}

// glut render fonksiyonu.
void displayCB( void ) {
 
   // bu degiskenle kubun donme acisini tutuyoruz.
   static float rotangle = 0.0f;
   
   // ekrani silme (color buffer clear) ve z-buffer i sifirlama(depth buffer clear)
   glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
   // her defasinda model_view matrisi resetliyoruz..
   glLoadIdentity();
   
   // cismi geri alalim ki tumunu ekranda gorebilelim..
   // ek olarak cismi eksenler etrafinda dondurerek demomuza bir miktar
   // heyecan ve hareket katiyoruz.. :)
   glTranslatef(0.0f,0.0f,-5.0f);
   glRotatef(rotangle,1.0f,0.0f,0.0f);
   glRotatef(rotangle*0.5f,0.0f,1.0f,0.0f);
   
   // cismi yeni renginde cizdirelim..
   // bu renk degeri tusa basilmalar sonucu degisebiliyor.. (widgetCB icerisinden...)
   glColor3f(color_red,color_green,color_blue);
   
   
   // CheckBox lar tarafindan secili olan render ozellikleri cizimden once uygulamamiz gerekiyor.
   // Once isiklarin acili olup olmamasina gore ayarlamamizi yapalim
   if (use_lighting_selected)
      glEnable(GL_LIGHTING);
   else
      glDisable(GL_LIGHTING);

   // ve wire frame modunu kontrol edelim
   if (wire_frame_selected)
      glPolygonMode(GL_FRONT_AND_BACK,GL_LINE);
   else
      glPolygonMode(GL_FRONT_AND_BACK,GL_FILL);
   
   
   // Simdi ise secili olan cismi cizdiriyoruz. Secili cisim LiveVariable ozelligi kullanilarak
   // selected_object degiskeni icerisinde GLUI tarafindan belirtiliyor.
   
   switch (selected_object) {
      case OT_CUBE:
         glutSolidCube(1.0f);
         break;
      case OT_SPHERE:
         glutSolidSphere(0.8f,20.0f,20.0f);
         break;
      case OT_TORUS:
         glutSolidTorus(0.3f,0.6f,20,20);
         break;
      case OT_TEAPOT:
         glutSolidTeapot(0.7f);
         break;

   }
   
   
   // csimi her seferinde biraz daha fazla donduruyoruz.
   rotangle += 0.1f;

   
   // goruntuyu ekrana getir.
   glutSwapBuffers(); 
}

// Bu yordam glui sistemi tarafindan bir widget ile islem yaptigimiz taktirde
// cagirilir. Ornegin bir butona bastiginizda, yada bir menu elemanini sectiginizde..
// wid degiskeni icerisinde islem yapilmis olan widget in belirtici numarasi bulunur..
// Bu numaralari widget i yaratirken sisteme belirtiyoruz.
void widgetCB(int wid) {

   // basitcene, basilan tusa gore kubun rengini kirmizi,yesil yada mavi yapiyoruz..
   switch(wid) {
      case WIDGET_BUTTON_RED:
         color_red   = 0.9f;
         color_green = 0.1f;
         color_blue  = 0.1f;
         break;

      case WIDGET_BUTTON_GREEN:
         color_red   = 0.1f;
         color_green = 0.9f;
         color_blue  = 0.1f;
         break;

      case WIDGET_BUTTON_BLUE:
         color_red   = 0.1f;
         color_green = 0.1f;
         color_blue  = 0.9f;
         break;

   };

}

// Bu yordam icerisinde glui widget larimizi ve ana glui kontrol penceresini yaratiyoruz..
void setupGLUIWidgets() {

   // ana glui control penceresini yarat..
   glui = GLUI_Master.create_glui("GLUI");
   // glut ile yarattigimiz render penceresini glui kontrol penceresine belirt..
   glui->set_main_gfx_window(main_window);
   
   // Ilk ornegimizden farkli olarak bu ornegimizde birbiriyle iliskili widget lari gruplandirarak
   // panel olarak adlandirilan widget lar icine yerlestirecegiz.
   // Ilk olarak bir panel yaratip bunu kontrol penceresine ekleyelim.
   // Bu panel in ust kisminda "Renk" yazacak.
   GLUI_Panel *renk_panel = glui->add_panel("Renk");
   
   // Simdide gecen ornekte oldugu gibi 3 adet buton u bu sefer yeni yarattigimiz panel e yerlestirelim.
   // gecen sefer add_button yordamini kullanmistik.. simdi ise add_button_to_panel yordamini kullanacagiz.
   // bu yordamin ilk parametresi ile buton u hangi panele yerlestirecegimizi belirtiyoruz.
   glui->add_button_to_panel(renk_panel,"Kirmizi",WIDGET_BUTTON_RED,widgetCB);
   glui->add_button_to_panel(renk_panel,"Yesil",WIDGET_BUTTON_GREEN,widgetCB);
   glui->add_button_to_panel(renk_panel,"Mavi",WIDGET_BUTTON_BLUE,widgetCB);

   // Bir panel daha yaratalim.
   GLUI_Panel *cisim_panel = glui->add_panel("Cisim");

   // Simdi yeni bir widget i kullanacagiz. Bu widget ListBox olarak adlandiriliyor. Basit olarak
   // icine stringler ekleyebilecegimiz bir liste. Listenin istenilen bir elemani secilebiliyor. Biz bu listeyi
   // cizilecek cismi kullaniciya sectirmek icin kullanacagiz. add_listbox_to_panel fonksiyonu ile bir listbox
   // yaratip bunu panel imize ekliyoruz. Bu fonksiyona gireceginiz bir string parametresi ile listbox
   // widget inin hemen soluna yazilmasini istediginiz metni belirtebiliyorsunuz.
   // Son parametre ise bir integer pointeri olmali. GLUI sistemi ListBox icerisinden bir eleman secildig zaman
   // otomatik olarak bu verdigimiz degiskenin icerigini secilen elemanin indisi ile gunler. Bu ozellik
   // "Live Variable" olarak adlandiriliyor. Bu ozelligi kullanmak yerine her defasinda ListBox da hangi
   // elemanin secili oldugunu da denetleyebilirdik ama boylesi cok daha zahmetsiz. Baz widget larda
   // event mekanizmas yerine LiveVariable kullanmak cok daha kolay oluyor. ListBox da bu widget lardan birisi.
   GLUI_Listbox *cisim_list = glui->add_listbox_to_panel(cisim_panel,"Seciniz: ",&selected_object);

   // Listemizi dolduruyoruz.
   cisim_list->add_item(0,"kup");
   cisim_list->add_item(1,"kure");
   cisim_list->add_item(2,"halka");
   cisim_list->add_item(3,"demlik");


   // Bir panel daha yaratalim. Bu panelin icerisine cesitli render opsiyonlarini degistirebilen widget lari
   // yerlestirmeyi planliyoruz.
   GLUI_Panel *options_panel = glui->add_panel("Cizim Ozellikleri");

   // Yeni bir GLUI widget i daha kullanacagiz. Bu widget CheckBox olarak adlandiriliyor. Bir opsiyonu acmak
   // yada kapamak istediginiz zamanlarda bu widget i kullanabilirsiniz. widget i yaratmak ve panelimiz
   // icine koymak icin add_checkbox_to_panel yordamini kullaniyoruz. LiveVariable ozelligini tekrar kullandik.
   // Bu seferde wire_frame_selected degiskeni icerisi secili olma durumunda 1 , aksi durumda 0 degeri ile
   // otomatik olarak gunlenecek.
   glui->add_checkbox_to_panel(options_panel,"wire frame",&wire_frame_selected);

   // Isik durumunu acip kapamak icin bir checkbox daha yerlestirelim.
   glui->add_checkbox_to_panel(options_panel,"use lighting",&use_lighting_selected);

   // glut idle callback yordamini GLUI kullanarak setliyoruz..
   GLUI_Master.set_glutIdleFunc(idleCB);    
}

int main(int argc,char **argv) {

   // standart glut fonksiyonlari ile bir glut penceresi yaratalim..
   glutInitDisplayMode(GLUT_RGBA | GLUT_DOUBLE | GLUT_DEPTH);
   glutInitWindowPosition(50,50);
   glutInitWindowSize(400,400);
   main_window = glutCreateWindow("GLUI test2 :: deniz@oyunyapimi.org :: 02/04/2004");
   
   // glut icin render ve reshape callback yordamlarini belirtelim
   // (idle i daha sonra glui kullanarak belirtecegiz..)
   glutDisplayFunc(displayCB);
   glutReshapeFunc(reshapeCB);  

   // biraz da opengl ile ilgili ayarlamalar yapalim.
   // oncelikle isik ayarlamalari..
   GLfloat light0_ambient[] =  {0.1f, 0.1f, 0.1f, 1.0f};
   GLfloat light0_diffuse[] =  {1.0f, 1.0f, 1.0f, 1.0f};
   GLfloat light0_position[] = {1.0f, 1.0f, 1.0f, 0.0f};

   glLightfv(GL_LIGHT0, GL_AMBIENT, light0_ambient);
   glLightfv(GL_LIGHT0, GL_DIFFUSE, light0_diffuse);
   glLightfv(GL_LIGHT0, GL_POSITION, light0_position);
   
   // fon rengi..
   glClearColor(0.0f,0.0f,0.0f,1.0f);
   
   // kullanacagimiz opengl durumlarini ayarlayalim..
   glEnable(GL_DEPTH_TEST);
   glEnable(GL_COLOR_MATERIAL);
   glEnable(GL_NORMALIZE);
   glDisable(GL_TEXTURE_2D);
   glDisable(GL_BLEND);
   glEnable(GL_LIGHT0);
   glEnable(GL_LIGHTING);

   // sira glui widget larini yaratmaya geldi..
   setupGLUIWidgets();

   // ana glut mesaj dongusune gir..
   glutMainLoop();
   return 0;
}


// Bu ikinci GLUI test programinda ilk ornegimizde kurdugumuz kod yapisi uzerinde cesitli eklemeler
// yaparak uygulamamizi gelistirmeye calistik. 3 yeni widget ogrendik: Panel, ListBox ve CheckBox
// Panel widget i diger widget lari konumlandirabilecegimiz bir alan olusturuyor. ListBox icerisinde
// birden cok secenegi secebilecegimiz bir liste, checkbox ise 2 secenek arasinda secim yapmada
// kullaniliyor.
// Bir widget i panel e eklerken kontrol penceresine widget eklemekte kullandigimiz add_XXXX
// seklindeki yordamlarin bu sefer add_XXX_to_panel(...) seklinde olanlarini kullaniyoruz.
// Bir panel e yada serbest olarak kontrol penceresine widget eklemek arasinda fazlaca bir fark yok.
// Bu ornegimizde ayrica "LiveVariable" olarak adlandirilan cok yararli GLUI ozelligini kullandik.
// ListBox nesnesi secili olan maddenin indis numarasini kendisini yaratirken belirttigimiz integer
// tipindeki degiskene otomatik olarak yaziyor, ayni sekilde CheckBox da secili olup olmadigini
// kendi LiveVariable ina gunluyor. Boylelikle her istedigimiz zaman bu degiskenlerin iceriklerini
// kontrol ederek GUI miz ile haberlesebiliyoruz. Bu yontemi kulllanarak callback yordamlari ve eventler
// ile ugrasmamaiza gerek kalmiyor.
//
// Kendinize iyi bakin.. Anlamadiginiz noktalari www.oyunyapimi.org forumlarinda tartismaktan
// kacinmayin..
//
// Deniz Aydinoglu :: 2004 :: www.oyunyapimi.org