// **********************************************************************
//
// GLUI  - opengl icin grafiksel kullanici arayuzu kutuphanesi
//
// Ornek-1
//
// Deniz Aydinoglu :: 2004 :: www.oyunyapimi.org
//
//
// ********** GLUI Nedir? ***********************************************
//
// GLUI platformdan bagimsiz bir OpenGL kullanici arabirimi kutuphanesidir.
// Paul Rademacher tarafindan gelistirilmekte olan bu kutuphanenin son
// versiyonu 2.1 dir (23.03.2004 tarihi ile..).. Projenin ana sayfasi ise:
// http://www.cs.unc.edu/~rademach/glui/
//
// GLUI kullanarak opengl uygulamalariniza buton, label, textbox, checkbox,
// listbox, panel, spinner gibi bircok gorsel arabirim ogesini ekleyebilirsiniz.
// 
// GLUI, GLUT kutuphanesi ile birlikte kullanilmak icin tasarlanmistir. Yani
// opengl uygulamanizda glui kullanabilmek icin tek on sart uygulamanizin glut
// kullanmasi gerekliligi. GLUT un isledigi her platform da glui yi kullanabilirsiniz.
//
// Glui kullanmanin bir cok guzel yani var. Belkide en guzel olani kutuphanenin
// oldukca sade ve kolay uygulanabilir olmasi. Cogu fonksiyonelligi kendisi
// otomatik olarak gerceklestiriyor. Az bir caba ile hemen kullanici arayuzleri
// olusturmaya baslayabiliyorsunuz. Kullanici arayuzu ile haberlesmede glut
// kullananlarin alisik oldugu callback mekanizmasi kullaniliyor. Bir glut
// programcisi glui ye hemen adapte olabilir..
//
// Peki ne kadar hizli? diye soracak olursaniz.. GLUI arabirimi render etmek icin
// standart opengl mekanizmasini kullaniyor. Dolayisi ile sizin sahnenizi render
// etmek icin kullandiginiz zamanin kucuk bir kismini aliyor. Ornekler, demolar
// ve editor uygulamalari icin rahatlikla kullanilabilir. Zaten gercek zamanli,
// hiz gerektiren uygulamalarda kullanici arayuzleri pek kullanilmaz. Sahsen ben
// bircok karisik tus basilma kombinasyonu ile kullanilan demo ve editorlerden biktim.
// Zaten MFC uygulamasi yazmakta kasici diyenlerdenseniz eminim glui cok hosunuza gidecek.
//
// ********** Derleyici Ayarlari Neler? *********************************
//
// GLUT kullanmak icin gerekli olan ayarlari yapin. Daha sonra glui.h ve glu32.lib
// dosyalarini proje directory sine yada detrleyicinin gorebilecegi biryerlere koyun,
// alternatif olarak vc++ kullanicilari bu dosyalari projelerine de ekleyebilirler.
//
// ********** Ilk GLUI Programimiz **************************************
//
// Ilk programimizda bir glut penceresi ve daha sonra glui komutlarini
// kullanarak birde glui control penceresi yaratacagiz. Glui kontrol
// penceresi glui widget lerini barindiran pencere. Istersek widget
// lari koymak icin ana glut penceresini de kullnabilirdik. (bu konuyu daha
// sonraki orneklere saklayalim). Glui kontrol penceresine 3 adet button
// widget i koyarak kullanici arayuzumuzu tamamlayacagiz. Kulanici her 
// button a bastigi zaman glut penceresine cizilen kubun rengi degisecek..

// GLUI yi kullanmak icin tek include etmemiz gereken header dosyasi glui.h
#include "glui.h"

// GLUI de gorsel bilesenleri widget olarak adlandiriyoruz. Butonlar, textbox lar,
// Label lar ve bunun gibi tum gorsel bilesenler widget tir.
// Asagida kullanacagimiz her 3 button widget ini belirtmek icin bir integer tam sayi
// tanimliyoruz. GLUI sistemi widget larimizi bu sayilar ile taniyacak.
enum eWidgetId { WIDGET_BUTTON_RED=0, WIDGET_BUTTON_GREEN, WIDGET_BUTTON_BLUE };

// bu degisken ana glui pencerimizi belirtecek.
static int main_window;

// ana glui pencere nesnesi.. widget yaratmak icin bu nesnenin fonksiyonlarini cagiracagiz.
static GLUI *glui;

// bu degiskenler ornegimizde donup duran kupun rengini belirtiyorlar.
// ilk basta kupun rengi beyaz..
float color_red   = 1.0f;
float color_green = 1.0f;
float color_blue  = 1.0f;

// klasik glut idle callback yordami..
void idleCB( void ) {

   // bu tanimi yapmamiz glui programlarimizin duzgun islemesi icin gerekli.
   if ( glutGetWindow() != main_window ) 
     glutSetWindow(main_window);  

   // idle icerisinde glut un goruntuyu tazelemesini istiyoruz..
   // yani displayCB yordami dolayli olarak cagiriliyor.
   glutPostRedisplay();
}

// klasik glut reshape callback yordami
// bu yordam her pencere boyutu degistiginde cagiriliyor.
// ayrica her program baslangicinda bir defaya mahsus olarakta cagirilmakta.
void reshapeCB( int x, int y ) {
  
   float xy_aspect;

   xy_aspect = (float)x / (float)y;
   glViewport(0,0,x,y);

   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   gluPerspective(50.0f,xy_aspect,0.1f,1000.0f);

   glMatrixMode(GL_MODELVIEW);
   glutPostRedisplay();
}

// glut render fonksiyonu.
void displayCB( void ) {
 
   // bu degiskenle kubun donme acisini tutuyoruz.
   static float rotangle = 0.0f;
   
   // ekrani silme (color buffer clear) ve z-buffer i sifirlama(depth buffer clear)
   glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
   // her defasinda model_view matrisi resetliyoruz..
   glLoadIdentity();
   
   // kubu biraz geri alalim ki tumunu ekranda gorebilelim..
   // ek olarak kubu eksenler etrafinda dondurerek demomuza bir miktar
   // heyecan hareket katiyoruz..
   glTranslatef(0.0f,0.0f,-5.0f);
   glRotatef(rotangle,1.0f,0.0f,0.0f);
   glRotatef(rotangle*0.5f,0.0f,1.0f,0.0f);
   
   // kubu yeni renginde cizdirelim..
   // bu renk degeri tusa basilmalar sonucu degisebiliyor.. (widgetCB icerisinden...)
   glColor3f(color_red,color_green,color_blue);
   glutSolidCube(1.0f);
   
   // kubumuzu her seferinde biraz daha fazla donduruyoruz.
   rotangle += 0.1f;

   
   // goruntuyu ekrana getir.
   glutSwapBuffers(); 
}

// Bu yordam glui sistemi tarafindan bir widget ile islem yaptigimiz taktirde
// cagirilir. Ornegin bir butona bastiginizda, yada bir menu elemanini sectiginizde..
// wid degiskeni icerisinde islem yapilmis olan widget in belirtici numarasi bulunur..
// Bu numaralari widget i yaratirken sisteme belirtiyoruz.
void widgetCB(int wid) {

   // basitcene, basilan tusa gore kubun rengini kirmizi,yesil yada mavi yapiyoruz..
   switch(wid) {
      case WIDGET_BUTTON_RED:
         color_red   = 0.9f;
         color_green = 0.1f;
         color_blue  = 0.1f;
         break;

      case WIDGET_BUTTON_GREEN:
         color_red   = 0.1f;
         color_green = 0.9f;
         color_blue  = 0.1f;
         break;

      case WIDGET_BUTTON_BLUE:
         color_red   = 0.1f;
         color_green = 0.1f;
         color_blue  = 0.9f;
         break;

   };

}

// Bu yordam icerisinde glui widget larimizi ve ana glui kontrol penceresini yaratiyoruz..
void setupGLUIWidgets() {

   // ana glui control penceresini yarat..
   glui = GLUI_Master.create_glui("GLUI");
   // glut ile yarattigimiz render penceresini glui kontrol penceresine belirt..
   glui->set_main_gfx_window(main_window);
   
   // kontrol penceremize 3 adet button widget i ekliyoruz.
   // add_button yordami bir adet button widget i yaratip kontrol penceresine ekler.
   // ilk parametre: button uzerindeki text, ikinci parametre bu butonu belirtmek icin kullandigimiz
   // sayi (handle), son parametre ise butona basildiginda cagirilmasini istedigimiz callback
   // yordamidir..
   glui->add_button("Kirmizi",WIDGET_BUTTON_RED,widgetCB);
   glui->add_button("Yesil",WIDGET_BUTTON_GREEN,widgetCB);
   glui->add_button("Mavi",WIDGET_BUTTON_BLUE,widgetCB);

   // glut idle callback yordamini GLUI kullanarak setliyoruz..
   GLUI_Master.set_glutIdleFunc(idleCB);    
}

int main(int argc,char **argv) {

   // standart glut fonksiyonlari ile bir glut penceresi yaratalim..
   glutInitDisplayMode(GLUT_RGBA | GLUT_DOUBLE | GLUT_DEPTH);
   glutInitWindowPosition(50,50);
   glutInitWindowSize(400,400);
   main_window = glutCreateWindow("GLUI test1 :: deniz@oyunyapimi.org :: 23/03/2004");
   
   // glut icin render ve reshape callback yordamlarini belirtelim
   // (idle i daha sonra glui kullanarak belirtecegiz..)
   glutDisplayFunc(displayCB);
   glutReshapeFunc(reshapeCB);  

   // biraz da opengl ile ilgili ayarlamalar yapalim.
   // oncelikle isik ayarlamalari..
   GLfloat light0_ambient[] =  {0.1f, 0.1f, 0.1f, 1.0f};
   GLfloat light0_diffuse[] =  {1.0f, 1.0f, 1.0f, 1.0f};
   GLfloat light0_position[] = {1.0f, 1.0f, 1.0f, 0.0f};

   glLightfv(GL_LIGHT0, GL_AMBIENT, light0_ambient);
   glLightfv(GL_LIGHT0, GL_DIFFUSE, light0_diffuse);
   glLightfv(GL_LIGHT0, GL_POSITION, light0_position);
   
   // fon rengi..
   glClearColor(0.0f,0.0f,0.0f,1.0f);
   
   // kullanacagimiz opengl durumlarini ayarlayalim..
   glEnable(GL_DEPTH_TEST);
   glEnable(GL_COLOR_MATERIAL);
   glEnable(GL_NORMALIZE);
   glDisable(GL_TEXTURE_2D);
   glDisable(GL_BLEND);
   glEnable(GL_LIGHT0);
   glEnable(GL_LIGHTING);

   // sira glui widget larini yaratmaya geldi..
   setupGLUIWidgets();

   // ana glut mesaj dongusune gir..
   glutMainLoop();
   return 0;
}

// Iste bu kadar. Cok az satir kod ile hemen bir kullanici arayuzu gerceklestirdik.
// Kodun buyuk kismida zaten standart GLUT ayarlamalari ile doldu.
// glutCreateWindow() yordami ile yarattigimiz glut penceresinin handle ini main_window
// degiskeninde sakladik..setupGLUIWidgets() yordami icerisinde GLUI_Master.create_glui()
// yordami ile glui kontrol penceresini yarattik ve glui->set_main_gfx_window(main_window);
// yordami ile bu kontrol penceresine ana glut penceresini belirttik.
// Daha sonra glui nesnesinin yordamlari ile kontrol penceresine 3 adet button ekledik.
// Dikkat etmeniz gereken nokta: glui de button yaratirken her button icin bir id numarasi
// (handle) da veriyoruz. Daha sonra glui sistemi buttona basildigi zaman yine bizim
// belirttigimiz callback yordamini bu id ile cagiriyor. Boylelikle hangi butona basildigini
// bilerek yapacagimiz isi yapiyoruz. Kullanimi basitlestirmek icin ben bir callback yordamini
// tum buttonlar icin kullandim, ve callback icerisinde switch ifadesi ile button ayirimini
// yaptim.. Bu yontem yerine her button icin ayri callback yordami da kullanilabilirdi..
//
// Kendinize iyi bakin.. Anlamadiginiz noktalari www.oyunyapimi.org forumlarinda tartismaktan
// kacinmayin..
//
// Deniz Aydinoglu :: 2004 :: www.oyunyapimi.org