//Evet uzun bir aradan sonra tekrar bir dkman.
//Bu uzun arann nedeninin benim tembelliimle uzaktan yakndan alakas yok.:D
//Tek sebebi okul.Ama bu gece biraz zaman ayrdm ve hallettim bu dkman.
//Sitedeki dkmanlar arasnda biraz dolandm ve OpenGL Quadricleri ile ilgili 
//birey olmadn grdm.Bu dkmanda quadriclerin ne olduunu ve nasl
//kullanldn renicez.
//lk olarak nedir bu quadricler??
//OpenGL ile kendi izimlerimizi yapabiliriz.Bunu izgilerle genlerle vs yapyoruz.
//Ama OGL iinde hazr gelen baz objeleride kullabiliriz.Bunlar OpenGL Utility Library iinde.
//Bu objeler;diskler,silindirler,koniler ve kreler.te bunlara quadricler deniyor.

//Nasl kullanrz??
//Programmzda quadricleri kullanmak iin nce bir tane yaratmamz lazm.iziceimiz sekil 
//ne olursa olsun nce bir tane quadric object tanmlamamz lazm.
// GLUquadricObj *pQuadObj;
//eklinde yaplabilir.
//Sonra gluNewQuadric(); fonksiyonu ile bunu yaratyoruz.
//Bundan sonra izilicek olan seklin ozelliklerini ayarlamak iin baz fonksiyonlarmz var. 
//bunlar:

//1-gluQuadricDrawStyle(GLUquadricObj *pObj,GLenum style);
//  Bu arkadamz izilicek eklin nasl izilicegini belirtiyor.lk parametre 
//tanmladmz quadric obje(pQuadObj),style parametresine unlar gelebilir
//GLU_FILL(ii dolu),GLU_LINE(izgi),GLU_POINT(noktalar),GLU_SILHOUTTE(siluet) yanl yazdk kesin 
//neyse :D

//2-gluQuadricNormals(GLUquadricObj *pObj,GLenum normal);
//  Bu fonksiyon ile cizicegimiz obje iin normallerin nasl yaratlacan ya da 
//yaratlmayacan belirtiyoruz.normal parametresi GLU_NONE olursa normaller yaratlmaz.Yani objemiz
//ktan etkilenmez.GLU_FLAT olursa her yzey iin bir normal oluturulur bu bize flat shading verir.
//her yzey tek tonda aydnlanr pek gzel bi grnt diil bugn iin :D.
//ve son olarak GLU_SMOOTH bununla objenin her noktas iin bir normal yaratlr ve gzel bir 
//aydnlanma elde ederiz.

//3-gluQuadricOrientation(GLUquadricObj *pObj,GLenum orientation);
// bu fonksiyon yaratlan normallerin ie mi da m dnk olduunu ayarlyor.
//orientation parametresi GLU_OUTSIDE olursa normaller da bakyor.GLU_INSIDE olursa 
//ie bakyor.Normaller da bakarsa objenin d aydnlanr ie bakarsa ii.

//4-gluQuadricTexture(GLUquadricObj *pObj,GLenum texCoords);
// bu fonksiyon ile objemiz iin textr koordinatlarnn yaratlp yaratlmayacagn belirliyoruz.
//eer objemize textr uygulayacaksak texCoords GL_TRUE uygulamayacaksak GL_FALSE olur.

//evet bunlar objelerimizin zelliklerini belirliyor.
//son olarak objeler ile izim iimiz bitince hafzadan silmek iin
// gluDeleteQuadric(GLUquadricObj *pObj); fonksiyonunu kullanyoruz ve ortal temizliyoruz :]

//Evet imdi programa gelelim bu kadar gevezelik yeter :)
//Win32 API kullanarak OpenGL Programlamaya giri dkman stne ekliyorum bu program
//o dkmann aklamalarn karyorum.
//eski dkman burda: 
//http://www.oyunyapimi.org/modules.php?name=Sections&op=viewarticle&artid=23

#define WIN32_LEAN_AND_MEAN   

#define SCREEN_WIDTH 800
#define SCREEN_HEIGHT 600
#define SCREEN_DEPTH 32

#include <windows.h>
#include <math.h>		//sin ve cos fonksiyonlarn kullacaz.
#include <stdlib.h>     //free komutu iin
#include <gl\gl.h>
#include <gl\glu.h>
#include <gl\glaux.h>	//textr yukleme iin

#pragma comment(lib,"opengl32.lib")
#pragma comment(lib,"glu32.lib")
#pragma comment(lib,"glaux.lib")

HDC g_hdc;
HGLRC g_hrc;
float aci=0.0f;

LRESULT CALLBACK WndProc (HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam);

int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nShowCmd)
{
	WNDCLASSEX winclass;
	HWND hwnd;
	MSG msg;
	GLUquadricObj *pQuadObj=0;	//Kullanacamz quadric obje!
	float lightPos[4]={-50.0f,0.0f,20.0f,0.0f};  //n yeri
	UINT  textureID;							 //texture iin
	bool bBitti;

	winclass.cbSize=sizeof(WNDCLASSEX);					
	winclass.style=CS_HREDRAW|CS_VREDRAW;				
														
	winclass.lpfnWndProc=WndProc;						
	winclass.cbClsExtra=0;								
	winclass.cbWndExtra=0;								
	winclass.hInstance=hInstance;						
														
	winclass.hIcon=LoadIcon(NULL,IDI_APPLICATION);		
	winclass.hCursor=LoadCursor(NULL,IDC_ARROW);        
	winclass.hbrBackground=(HBRUSH)GetStockObject(WHITE_BRUSH);	
	winclass.lpszMenuName=NULL;							
	winclass.lpszClassName="patlican";					
	winclass.hIconSm=LoadIcon(NULL,IDI_WINLOGO);		

	
	
	if(RegisterClassEx(&winclass)==NULL)
		return 0;
		
	hwnd = CreateWindowEx(NULL,								
						  "patlican",						
						  "Quadricler ile Dnya",			
						  WS_OVERLAPPEDWINDOW,				
						  100,100,							
						  SCREEN_WIDTH,SCREEN_HEIGHT,		
						  NULL,								
						  NULL,								
						  hInstance,						
						  NULL);							
		
	if(hwnd==NULL)
		return 0;
	
	
	PIXELFORMATDESCRIPTOR pfd;
		
    pfd.nSize = sizeof(PIXELFORMATDESCRIPTOR);		
    pfd.nVersion = 1;								
    pfd.dwFlags = PFD_DRAW_TO_WINDOW				
		         | PFD_SUPPORT_OPENGL				
				 | PFD_DOUBLEBUFFER;				
    pfd.dwLayerMask = PFD_MAIN_PLANE;				
    pfd.iPixelType = PFD_TYPE_RGBA;					
													
    pfd.cColorBits = SCREEN_DEPTH;					
    pfd.cDepthBits = 16;							
    pfd.cAccumBits = 0;								
    pfd.cStencilBits = 0;							
 	
	g_hdc=GetDC(hwnd);
    

	int nPixelFormat;
    if ((nPixelFormat=ChoosePixelFormat(g_hdc,&pfd))==FALSE ) 
   	{ 
    	MessageBox(NULL, "Pixel Format seme baarsz!", "Hata", MB_OK); 
		PostQuitMessage(0);       
    } 
 
	if (SetPixelFormat(g_hdc, nPixelFormat, &pfd) == FALSE) 
    { 
    	MessageBox(NULL, "SetPixelFormat baarsz!", "Hata", MB_OK); 
		PostQuitMessage(0);
        
    } 
	
	
	g_hrc=wglCreateContext(g_hdc);
	wglMakeCurrent(g_hdc,g_hrc);
		
	//quadric objemizi yaratyoruz.
	//eer yaratmazsak program aklr. :D
	pQuadObj = gluNewQuadric();
	///Burda quadric obje ile ilgili bir ka ayar yapcaz en bata anlattm fonksiyonlar kullanarak.
	//objemizi ii dolu cizicez.
	gluQuadricDrawStyle(pQuadObj,GLU_FILL);
	//her nokta iin bir normal istiyoruz.
	gluQuadricNormals(pQuadObj,GLU_SMOOTH);
	//normaller dar bakyor.
	gluQuadricOrientation(pQuadObj,GLU_OUTSIDE);
	//texture kordinatlarnn yaratlmasn istiyoruz.
	gluQuadricTexture(pQuadObj,GL_TRUE);
	

	//dier OpenGL ayarlar
	glEnable(GL_CULL_FACE);	//arka yzleri izmek istemiyoruz.
	glEnable(GL_LIGHTING);	//klandrmay ayoruz.
	glEnable(GL_LIGHT0);	//0 numaral  aktif hale getiriyoruz.
	glEnable(GL_TEXTURE_2D);//textureleri aktif hale getiriyoruz.
	//bu fonksiyon ile n yerini deitirebiliyoruz.
	glLightfv(GL_LIGHT0,GL_POSITION,lightPos);
	
	//texture ykleme.
	//buralar aklamyorum fazla uzamasn diye.
	//burda sadece harddiskten world.bmp adl dosyay yklyoruz ve texture olarak hazrlyoruz.
	AUX_RGBImageRec *pBitmap = NULL;
	pBitmap = auxDIBImageLoad("world.bmp");
	
	if(pBitmap == NULL)					
		return 0;
	glGenTextures(1, &textureID);
	glBindTexture(GL_TEXTURE_2D, textureID);
	gluBuild2DMipmaps(GL_TEXTURE_2D, 3, pBitmap->sizeX, pBitmap->sizeY, GL_RGB, GL_UNSIGNED_BYTE, pBitmap->data);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);	

	if (pBitmap)										
	{
		if (pBitmap->data)								
			free(pBitmap->data);						
		free(pBitmap);									
	}
	
	ShowWindow(hwnd,SW_MAXIMIZE); 
	//SW_MAXIMIZE pencereyi tam ekran yapyor.
	UpdateWindow(hwnd);
	
	bBitti=false;
		
	while(bBitti==false)
	{
		if(PeekMessage(&msg, NULL, NULL, NULL, PM_REMOVE))
		{
			if (msg.message == WM_QUIT)		
				bBitti = true;				
			TranslateMessage(&msg);		
			DispatchMessage(&msg);
		}
		
		
		glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
		glLoadIdentity();
		
		
		glTranslatef(0.0f,-10.0f,-200.0f);
		
		glRotatef(aci,0.0f,1.0f,0.0f);
		glRotatef(-90.0f,1.0f,0.0f,0.0f);//dnyann dz grnmesi iin 90 derece dndrmek gerekiyor
		
						
		aci+=0.2f;
		if(aci>=360.0f) aci=0.0f;
		
		//yklediimiz texture i seiyoruz.
		glBindTexture(GL_TEXTURE_2D,textureID);
		///bir kre ciziyoruz.
		//parametreler srasyla.
		//quadric objemiz.
		//yarap
		//boyuna kesitler
		//enine kesitler
		gluSphere(pQuadObj,50.0f,100,100);

		
		SwapBuffers(g_hdc);
		
				
	}
	//program bitmeden quadric objemizi siliyoruz.
	gluDeleteQuadric(pQuadObj);
	DestroyWindow(hwnd);
	UnregisterClass("patlican",hInstance);
	return msg.wParam;
}
LRESULT CALLBACK WndProc (HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
	int  height,width;
	switch(iMsg)
	{
	case WM_CREATE:
		break;
	case WM_SIZE:
		width = LOWORD(lParam);  
		height = HIWORD(lParam); 
				
		if (height==0)					
		{							
			height=1;
		}
		glViewport(0,0,width,height);	
		glMatrixMode(GL_PROJECTION);	
		glLoadIdentity();				
		gluPerspective(45.0f,(GLfloat)width/(GLfloat)height, 1 ,1000.0f);
		glMatrixMode(GL_MODELVIEW);		
		glLoadIdentity();				
		break;
		case WM_DESTROY:
			wglMakeCurrent(NULL,NULL);
			wglDeleteContext(g_hrc);
			PostQuitMessage(0);
			return 0;
	}
	return DefWindowProc(hwnd, iMsg, wParam, lParam);	
}

////Notlar:
// Bu program Microsoft Visual C++ 6.0 ile yazlmtr.
// Programn almas iin opengl ktphanelerinin bilgisayarnzda bulunmas gerekli 
// ayrca yeni bir proje yaratrken win32 application semelisiniz.
//  
// Bu programda anlatmadgm baz ksmlar var texture ykleme olay mesela.Dkmann amac 
//quadricleri anlatmakt bu yzden o ksmlar getim.Sadece sonucun guzel gzkmesi iin texture 
//ve klandrma koydum.o ksmlar anlamyorsanz nemli diil.
//Quadriclerden sadece kreyi cizdik dierleri neler peki??Onlar nasl iziyoruz tamam panik yok :]
//Dier quadricler iin fonksiyonlar unlar.

// Silindirler iin:
// void gluCylinder(GLUquadricObj *qobj,GLdouble baseRadius,GLdouble topRadius,GLdouble height,GLint slices,GLint stacks);
// baseRadius taban yarap,topRadius tavan yarap,height boy,slices boyuna kesitler,stacks enine kesitler,

// Diskler iin :
// void gluDisk(GLUquadricObj * qobj,GLdouble innerRadius,GLdouble outerRadius,GLint slices,GLint loops);
// innerRadius i ap,outerRadius d ap,slices kesitler,loops halkalar,

// Belli bi miktar disk iin :)))
// void gluPartialDisk(GLUquadricObj * qobj,GLdouble innerRadius,GLdouble outerRadius,GLint slices,GLint loops,GLdouble startAngle,GLdouble sweepAngle);
// bundaki fark diskin hangi acdan baslcagn ve nekadarlk bir ac cizicegini belirtebilmeniz.startAngle balama as sweepAngle da miktar.

// Evet imdi son birka not daha ve tamamz.Diyelim ki koni yapmak istediniz.O zaman tepesinin yarap sfr olan bir silindir 
// yapyorsunuz ve koniniz oluyor. :] yada altn sfr yaparsnz ters koniniz olur.
// Baka bir konu slice,stack ler ile ilgili.Bu deerler cizdiginiz objenin kalitesini belirliyor eer azaltrsanz obje daha az 
// polygon ile iziliyor ve kalitesi dyor bu kalite fark klandrmada da kendini belli ediyor o yzden ok dk deerler
// kullanmanz tavsiye etmiyorum.
// Evet geldik bir dkmann daha sonuna.Eer anlalmayan bir eyler varsa.
// 1) Forumda sorabilirsiniz.
// 2) Irc kanalnda sorabilirsiniz.(irc.enterthegame.com #oyunyapimi)
// 3) Bana mail atabilirsiniz(busakli@shadowytree.com)
// 4) Kendiniz halletmeye alabilirsiniz.
// 
// Benden bu kadar :]


