#include "image.h"

#include "log.h"

#include <string.h>		// strlen
#include <ctype.h>		// toupper

image_t LoadImageFile( const char * filename )
{
	int			fnlen;
	char		ft[4];
	image_t		image;

	memset( &image, 0, sizeof(image_t) );

	fnlen = strlen( filename );
	ft[3] = '\0';
	ft[2] = toupper( filename[ fnlen-1 ] );
	ft[1] = toupper( filename[ fnlen-2 ] );
	ft[0] = toupper( filename[ fnlen-3 ] );

	if ( strcmp(ft, "TGA") == NULL )
	{
		return LoadTGA( filename );
	}
	else if ( strcmp(ft, "BMP")==NULL )
	{
		return LoadBMP( filename );
	}

	return image;
}
