#include "tga.h"

#include "log.h"

#include <string.h>
#include <ctype.h>
#include <assert.h>
#include <malloc.h>
#include <stdio.h>

//
image_t LoadTGA(const char *filename)
{
	FILE			*file;
	image_t			image;
	unsigned int	i;
	unsigned char	info[18];

	memset( &image, 0, sizeof(image_t) );

	file = fopen( filename, "rb" );
	if ( file==NULL )
	{
		logOutput( "HATA : %s Dosyas Alamyor.. \n", filename );
		return image;
	}

	fread( info, 18, 1, file );

	image.width		= info[12] + info[13]*256;
	image.height	= info[14] + info[15]*256;

	switch ( info[16] )
	{
	case 32:
		image.type				= IMAGE_RGBA;
		image.BitsPerPixel		= 32;
		break;

	case 24:
		image.type				= IMAGE_RGB;
		image.BitsPerPixel		= 24;
		break;

	default:
		logOutput( "HATA : Sadece 24 ve 32 bit TGA dosyalar okunabilir!(%s) \n", filename );
		fclose( file );
		return image;
	}

	image.imageSize = image.width * image.height * image.BitsPerPixel;

	image.data = (unsigned char *)malloc( image.imageSize );

	if ( image.data == NULL )
	{
		logOutput( "HATA : --- \n" );
		fclose( file );
		return image;
	}

	if ( info[2] != 2 )
	{
		logOutput( "HATA : ---\n" );
		fclose( file );
		return image;
	}

	//fseek( file, info[0], SEEK_SET );
	fread( image.data, image.imageSize, 1, file );
	fclose( file );

	// BGR -> RGB ( ilk ve nc byte lar yer deitirir )
	// Not: ^=  XOR demek!
	for ( i=0; i<image.imageSize; i += (image.BitsPerPixel/8))
	{
		image.data[i] ^= image.data[i+2] ^= image.data[i] ^= image.data[i+2];
	}

	logOutput( "%s \t TGA Dosyas Baaryla Yklendi(UC TGA) \n", filename );

	return image;
}