#ifndef _TUNEL_H__
#define _TUNEL_H__

#define PI_BOL_180	0.0174532925199432957692369076848861f

typedef float	vec_t;
typedef vec_t	vec2_t[2];
typedef vec_t	vec3_t[3];
typedef vec_t	vec4_t[4];
typedef vec_t	vec5_t[5];

//
struct ring_t{
	vec3_t		center;				// Halka merkezi
	float		xangle, yangle;		// Halkalarn eksenlerle yapt alar
	float		tmat[9];			// transform matris
	float		radius;				// Halka yarap

	vec3_t		*vertexLump;		// Halkalarn noktalar
	vec3_t		*normalLump;		// Halka nokta normalleri
	vec2_t		*texcoordLump;		// texture koordinatlar
	unsigned int	texID;
};

// --- TUNNEL ---
struct tunnel_t{
	int			numRing;	// Bu tnelde ka tane halka var
	int			numVertex;	// Herbir ring'deki vertex says
	float		width;		// Arka arkaya iki halka merkezi arasndaki mesafe
	ring_t		*ringLump;	// Halkalar
};


int	CreateEmptyTunnel( tunnel_t *tunnel, int nRing, int nVertex, float radius, float w );
void RenderTunnel( tunnel_t tunnel, int nRing, int numRing, float dist, float tX, float tY );
void CompileTunnel( tunnel_t *tunnel );

void tMakeTexture( tunnel_t *tunnel, int texID, int sRing, int eRing, float uScale, float vScale );

void tApply_1Y( tunnel_t *tunnel, int start, int end, int wsize );
void tApply_1X( tunnel_t *tunnel, int start, int end, int wsize );

#endif