#include <windows.h>
#include <gl/gl.h>
#include <gl/glu.h>
#include <math.h>

#include "log.h"
#include "image.h"
#include "tunel.h"

LRESULT CALLBACK	MainProc( HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
void				ResizeGL(int width, int heignt);

BOOL		sys_done = FALSE;
HWND		hWnd;
HDC			hDC;
HGLRC		hRC;

tunnel_t		tunnelOn;

LARGE_INTEGER	li_frequency;
LARGE_INTEGER	li_counterBegin, li_counterEnd, li_counterElapsed;

int			keys[256];

int			pl_onRing;
float		pl_distance;
int			pl_numRing;
float		pl_speed;

float		cmr_tx, cmr_ty;

void CreateGL(int fullscr)
{
	HINSTANCE	hInstance;
	WNDCLASS	wc;
	int			width, height;
	DWORD		style;

	if ( fullscr )
	{
		style = WS_POPUP;
		width = GetSystemMetrics( SM_CXSCREEN );
		height = GetSystemMetrics( SM_CYSCREEN );
	}
	else
	{
		style = WS_OVERLAPPEDWINDOW;
		width = 512;
		height = 512;
	}

	hInstance			= GetModuleHandle(NULL);

	wc.style			= CS_HREDRAW | CS_VREDRAW | CS_OWNDC;
	wc.lpfnWndProc		= (WNDPROC) MainProc;
	wc.cbClsExtra		= 0;
	wc.cbWndExtra		= 0;
	wc.hInstance		= hInstance;
	wc.hIcon			= LoadIcon(NULL, IDI_WINLOGO);
	wc.hCursor			= LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground	= NULL;		// OpenGL programlarnda arka plan rengi tanmlanmaz								// No Background Required For GL
	wc.lpszMenuName		= NULL;
	wc.lpszClassName	= "class_OpenGL";	// snf isimi

	RegisterClass(&wc);
	
	hWnd=CreateWindowEx(	WS_EX_WINDOWEDGE,		// Kabartlm pencere kenarlar
							"class_OpenGL",			// Snf ismi
							"Tnel Demo",			// Pencere Bal
							style |					// Pencere biimi
							WS_CLIPSIBLINGS |		// GL in Gerekli Pencere Biimi
							WS_CLIPCHILDREN,		// GL in Gerekli Pencere Biimi
							0, 0,					// Pencere Pozisyonu
							width,		// Pencere Genilii
							height,		// Pencere Ykseklii
							NULL,		// st Pencere Yok
							NULL,		// Men yok
							hInstance,	// Program
							NULL);		// WM_CREATE mesajna parametre geilmiyor
	
	ShowWindow( hWnd, SW_SHOW );	// Pencere grnr yaplr
	SetForegroundWindow(hWnd);		// Pencere en ne alnr
	SetFocus(hWnd);					// Klavye mesajlar bu pencereye gider
}

//
void keyFunc(void)
{
	static int pm = 1;

	if ( keys['M'] )
	{
		if ( pm==1 )
			glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
		else
			glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);

		pm *= -1;
		keys['M'] = FALSE;
	}

	if ( keys[ VK_ESCAPE ] )
		DestroyWindow( hWnd );

	if ( keys[ VK_UP ] )
		cmr_ty -= ((float)li_counterElapsed.QuadPart / li_frequency.QuadPart )*0.3f;

	if ( keys[ VK_DOWN ] )
		cmr_ty += ((float)li_counterElapsed.QuadPart / li_frequency.QuadPart )*0.3f;

	if ( keys[ VK_LEFT ] )
		cmr_tx -= ((float)li_counterElapsed.QuadPart / li_frequency.QuadPart )*0.3f;

	if ( keys[ VK_RIGHT ] )
		cmr_tx += ((float)li_counterElapsed.QuadPart / li_frequency.QuadPart )*0.3f;

	if ( keys[ VK_PRIOR ] )	// Page UP
	{
		pl_speed += 0.01f;
	}

	if ( keys[ VK_NEXT ] )	// Page Down
	{
		pl_speed -= 0.01f;
	}

	if ( keys[ VK_SPACE ] )
	{
		cmr_tx = 0.0f;
		cmr_ty = 0.0f;
		pl_speed = 1.0f;
	}
}

void InitTunnel(void)
{
	image_t			im_texA, im_texB, im_texC;
	unsigned int	texA_ID, texB_ID, texC_ID;

	CreateEmptyTunnel(	&tunnelOn, 
						450,		// Ka tane halka(ember)
						30,			// Her halkada ka vertex
						0.2f,		// Her halkann yarap
						0.2f );		// halka genilikleri

	// 1. Texture Yklenir
	im_texA = LoadImageFile( "bugtex.TGA" );
	glGenTextures( 1, &texA_ID );
	glBindTexture( GL_TEXTURE_2D, texA_ID );
	glTexImage2D(	GL_TEXTURE_2D, 
					0, 
					im_texA.BitsPerPixel / 8, 
					im_texA.width, 
					im_texA.height, 
					0, 
					GL_RGB, 
					GL_UNSIGNED_BYTE,
					im_texA.data	);
	glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR );
	glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR );
	free( im_texA.data );

	// 2. Texture Yklenir
	im_texB = LoadImageFile( "base02.tga" );
	glGenTextures( 1, &texB_ID );
	glBindTexture( GL_TEXTURE_2D, texB_ID );
	glTexImage2D(	GL_TEXTURE_2D,
					0,
					im_texB.BitsPerPixel/8,
					im_texB.width,
					im_texB.height,
					0,
					GL_RGB,
					GL_UNSIGNED_BYTE,
					im_texB.data	);
	glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR );
	glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR );
	free( im_texB.data );

	// 3. Texture Yklenir
	im_texC = LoadImageFile( "doorbot.TGA" );
	glGenTextures( 1, &texC_ID );
	glBindTexture( GL_TEXTURE_2D, texC_ID );
	glTexImage2D(	GL_TEXTURE_2D,
					0,
					im_texC.BitsPerPixel/8,
					im_texC.width,
					im_texC.height,
					0,
					GL_RGB,
					GL_UNSIGNED_BYTE,
					im_texC.data	);
	glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR );
	glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR );
	free( im_texC.data );

	// Yklenen texture'ler yerletirilir
	tMakeTexture(	&tunnelOn,	// Hangi tnele
					texA_ID,	// texture ID'si
					0,			// Hangi halkadan
					150,		// Hangi halkaya kadar
					5.0f,		// Texture Byklk(u)
					0.1f	);	// Texture Byklk(v)

	tMakeTexture(	&tunnelOn,
					texB_ID,
					150,
					300,
					5.0f,
					0.4f	);

	tMakeTexture(	&tunnelOn,
					texC_ID,
					300,
					tunnelOn.numRing-1,
					5.0f,
					0.4f	);

	// ekil
	tApply_1X( &tunnelOn, 1, 360, 20 );
	tApply_1Y( &tunnelOn, 1, 360, 60 );

	int i;
	for ( i=100; i<150; i++ )
	{
		tunnelOn.ringLump[i].radius = tunnelOn.ringLump[i-1].radius+0.01f;
	}

	for ( i=150; i<200; i++ )
	{
		tunnelOn.ringLump[i].radius = tunnelOn.ringLump[i-1].radius-0.01f;
	}

	//
	CompileTunnel( &tunnelOn );
}

//
void InitGL(void)
{
	pl_onRing	= 0;
	pl_numRing	= 100;
	pl_distance = 0.0f;
	pl_speed	= 1.0f;	// Saniyedeki mesafe

	cmr_tx = 0.0f; cmr_ty = 0.0f;
	
	glEnable(GL_DEPTH_TEST);
	glClearColor(0.0, 0.0, 0.0, 0.0);

	glEnable( GL_LIGHTING );
	glEnable( GL_LIGHT0 );

	glEnable( GL_TEXTURE_2D );
}

void ResizeGL(int width, int height)
{
	glViewport(0, 0, width, height);	// Pencerenin tamam kullanlr

	// OpenGL iin Kamera ve Model Konumlar
	glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		gluPerspective(	45.0f,					// Gz ile perde arasndaki a
						(float)width/height,	// Perde iin genilik/ykseklik
						0.001f,					// En yakn
						999999.0f);				// En uzak

	glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
}

void RenderGL(void)
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	glLoadIdentity();
	RenderTunnel(	tunnelOn, 
					pl_onRing,		// Kanc halkadan
					pl_numRing,		// Ka tane daha izilecek
					pl_distance,	// bu halkann nekadar uzandan
					cmr_tx,			// X
					cmr_ty	);		// Y
}

int WINAPI WinMain( HINSTANCE hInstance, 
					HINSTANCE hPrevInstance,
					LPSTR lpCmdLine, 
					int nShowCmd )
{
	MSG			msg;
	logFileOpen( "gunluk.txt" );

	if ( MessageBox( NULL, "Tam Ekran alsn m?", "Tam Ekran", MB_YESNO | MB_ICONQUESTION )==IDYES )
	{
		CreateGL( TRUE );
		ShowCursor( FALSE );
	}
	else
	{
		CreateGL( FALSE );
	}

	InitGL();
	InitTunnel();

	QueryPerformanceFrequency( &li_frequency );
	logOutput( "FREQUENCY : %u \n", li_frequency.QuadPart );

	li_counterElapsed.QuadPart = li_frequency.QuadPart; // Balang iin

	while ( !sys_done )
	{
		if (PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE))
		{
			if (!GetMessage(&msg, NULL, 0, 0))
				sys_done=TRUE;

			TranslateMessage( &msg );	// Baz klavye mesasjlarn kullanmak iin
			DispatchMessage( &msg );	// Pencere Fonksiyonu arlr
		}
		keyFunc();

		// Kamera tnel dna kamaz
		float	d;
		d = sqrtf( cmr_tx*cmr_tx + cmr_ty*cmr_ty );
		if ( d > (tunnelOn.ringLump[ pl_onRing ].radius-0.01f) )
		{
			cmr_tx *= (tunnelOn.ringLump[ pl_onRing ].radius-0.01f) / d;
			cmr_ty *= (tunnelOn.ringLump[ pl_onRing ].radius-0.01f) / d;
		}

		//
		if ( pl_speed < -2.0f )
			pl_speed = -2.0f;

		if ( pl_speed > 2.0f )
			pl_speed = 2.0f;

		QueryPerformanceCounter( &li_counterBegin );

		RenderGL();
		SwapBuffers(hDC);

		QueryPerformanceCounter( &li_counterEnd );
		li_counterElapsed.QuadPart = li_counterEnd.QuadPart - li_counterBegin.QuadPart;

		// Anim

		// Sonraki konum hesaplanr
		pl_distance += ((float)li_counterElapsed.QuadPart / li_frequency.QuadPart)*pl_speed;
		while ( pl_distance > tunnelOn.width )
		{
			pl_onRing++;
			pl_distance -= tunnelOn.width;
		}

		while ( pl_distance < 0 )
		{
			pl_onRing--;
			pl_distance += tunnelOn.width;
		}

		if ( pl_onRing > (tunnelOn.numRing-1) )
			pl_onRing = 0;

		if ( pl_onRing < 0 )
			pl_onRing = tunnelOn.numRing-1;
	}

	logFileClose();

	return 0;
}

void InitPixelFormat(HWND hWnd)
{
	PIXELFORMATDESCRIPTOR	pfd;
	int		PixelFormat;

	memset( &pfd, 0, sizeof(pfd) );

	pfd.nVersion	= 1;
	pfd.nSize		= sizeof(pfd);
	pfd.dwFlags		= PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | PFD_DOUBLEBUFFER;
	pfd.iPixelType	= PFD_TYPE_RGBA;
	pfd.cColorBits	= 16;
	pfd.cDepthBits	= 16;
	pfd.iLayerType	= PFD_MAIN_PLANE;
	
	hDC=GetDC(hWnd);

	PixelFormat=ChoosePixelFormat(hDC,&pfd);

	SetPixelFormat(hDC,PixelFormat,&pfd);

	hRC=wglCreateContext(hDC);

	wglMakeCurrent(hDC,hRC);
}

LRESULT CALLBACK MainProc( HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch ( message )
	{
	case WM_CREATE:
		InitPixelFormat( hWnd );
		return 0;

	case WM_QUIT:
		sys_done=TRUE;
		return 0;

	case WM_KEYDOWN:
		keys[wParam] = TRUE;
		return 0;

	case WM_KEYUP:
		keys[wParam] = FALSE;
		return 0;

	case WM_DESTROY:
		wglMakeCurrent(NULL, NULL);
		wglDeleteContext(hRC);

		PostQuitMessage(0);
		return 0;

	case WM_SIZE:
		ResizeGL(LOWORD(lParam), HIWORD(lParam));
		return 0;
	}

	return DefWindowProc( hWnd, message, wParam, lParam );
}