#ifndef _OBJ_H
#define _OBJ_H
#include "main.h"

// Doku kordinatlarn saklamak iin kullanacaz
struct Vektor2{
	float u;
	float v;
};

// Vertex ve normal deerlerini saklamak iin
struct Vektor3{
	float x;
	float y;
	float z;
};

// Bir ucgenin hangi vertex,normal,doku koordinatlarn kullandn saklamak iin.
// Bu bilgi ile o ucgenin vertexini,normalini.. bulup izeceiz.
struct OBJ_Face
{
	int vertexIndex[3]; // Bu ucgenin hangi vertexlerden olutuunu belirten indeks 
	int textureIndex[3];// Hangi doku kordinatlarn kullandn gosteren indeks
	int normalIndex[3]; // Hangi normali kullandn gosteren indeks
};

class CObj
{

public:
	
	//Yapc ve ykc metodlar
	CObj();

	~CObj();
	
	// LoadObj ye fonksiyonu parametrede belirten dosyadan verileri okuyup
	// ye deikenlerimize atyacak.
	void LoadObj(const char *dosya);
	
	// Modelimizi izmek iin
	void Render();

	// Ayrlan bellein program sonunda geri iadesi iin
	void Destroy();

private:
	
	// Bu metod sayesinde modelimizin kac adet vertex,normal,doku koordinati ve ucgene
	// sahip olduunu renip aada m_num ile balayan deikenlere atyoruz.
	void GetNums(FILE *fp);

	int  m_numVerts;     // Vertex sayisi
	int  m_numNormals;   // Normal sayisi
	int  m_numTexCoords; // Doku koordinatlari sayisi
	int  m_numFaces;	 // Ucgen sayisi

	// Bu iaretilere, yukardaki sayilar kadar yer ayrlacak.
	Vektor3		*m_pVerts;    // vertex dizisi
	Vektor3		*m_pNormals;  // normal dizisi		
	Vektor2		*m_pTexCoords;// doku koordinatlari dizisi
	OBJ_Face	*m_pFaces;	  // ucgen indeksleri dizisi	

};



#endif