#include <lib3d/util3d/vector3d.h>

Vector3d :: Vector3d(float x,float y,float z) {
   set(x,y,z);
}

Vector3d :: Vector3d(int x,int y,int z) {
   set((float)x,(float)y,(float)z);
}

void Vector3d :: zero() {
   set(0.0f,0.0f,0.0f);
}

void Vector3d :: normalize() {
   float len = length();
   x /= len;
   y /= len;
   z /= len;
}

float Vector3d :: length() const {
   return (float) sqrt(x*x+y*y+z*z);
}

bool Vector3d :: equals(const Vector3d *v) const {
   if (x == v->x && y == v->y && z == v->z) return true;
   else return false;
}

void Vector3d :: invert() {
   x = -x;
   y = -y;
   z = -z;
}

void Vector3d :: set(float x,float y,float z) {
   this->x = x;
   this->y = y;
   this->z = z;
}

void Vector3d :: set(const Vector3d *v) {
   this->x = v->x;
   this->y = v->y;
   this->z = v->z;
}

void Vector3d :: scale(const Vector3d *s) {
   x *= s->x;
   y *= s->y;
   z *= s->z;
}

void Vector3d :: scale(float sx,float sy,float sz) {
   x *= sx;
   y *= sy;
   z *= sz;
}

float Vector3d :: dot(const Vector3d *v) {
   return (v->x*x + v->y*y + v->z*z);
}

void Vector3d :: cross(const Vector3d *v) {
   set (y * v->z - z * v->y,
        z * v->x - x * v->z,
        x * v->y - y * v->x);
}

void Vector3d :: add(const Vector3d *vec) {
   x += vec->x;
   y += vec->y;
   z += vec->z;
}
   
void Vector3d :: add(float x,float y,float z) {
   this->x += x;
   this->y += y;
   this->z += z;
}
   
void Vector3d :: sub(const Vector3d *vec) {
   x -= vec->x;
   y -= vec->y;
   z -= vec->z;
}
   
void Vector3d :: sub(float x,float y,float z) {
   this->x -= x;
   this->y -= y;
   this->z -= z;
}

Vector3d Vector3d :: cross(const Vector3d *vec1,const Vector3d *vec2) {

   Vector3d vec3;
   vec3.x = vec1->y * vec2->z - vec1->z * vec2->y;
   vec3.y = vec1->z * vec2->x - vec1->x * vec2->z;
   vec3.z = vec1->x * vec2->y - vec1->y * vec2->x;
   return vec3;
}
   
float Vector3d :: dot(const Vector3d *v1,const Vector3d *v2) {
   return (v1->x*v2->x + v1->y*v2->y + v1->z*v2->z);
}

void Vector3d :: print(FILE *fp) const {
   fprintf(fp,"[%f,%f,%f]",x,y,z);
}

Vector3d* Vector3d :: clone() const {
   return new Vector3d(x,y,z);
}
