#ifndef __TEXTURE_H__
#define __TEXTURE_H__

#ifdef WIN32
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#endif

#pragma warning (disable : 4786)

#include <stdlib.h>
#include <string.h>

#include <gl/gl.h>
#include <gl/glu.h>

#include <lib3d/gl/glext_small.h>
#include <lib3d/util2d/TextureManager.h>
#include <lib3d/util2d/tga/glTga.h>
#include <lib3d/util2d/shaders/ShaderLoader.h>
#include <lib3d/util/Simpletimer.h>

#include <sdl/sdl.h>
#include <sdl/sdl_image.h>

class Stage;

class Texture {

public:

   Texture(const char *path);
   ~Texture();

   bool isExists();
   void setShaderTimer(SimpleTimer *st);
   void enableMipmapping(bool b);
   void setWrapS(int ws);
   void setWrapT(int wt);
   bool build();
   void makeCurrent();
   void begin();
   void end();
   void apply(float u,float v);
   void resetShaders();
   Stage* getStages();
   int   getStageCount();
   unsigned int getId();
   void render();

private:

   bool build_shaders();
   SDL_Surface* load_using_SDL_image(char *filename);
   
   unsigned int id;
   char path[255];
   bool useMipMaps;
   bool useShaders;
   int  wrapS,wrapT;

   int   stageCount;
   Stage *stages;
   SimpleTimer *shaderTimer;

};



#endif