#include "PropReader.h"

PropReader :: PropReader(const char *path) {

   err = 0;
   
   fp = fopen(path,"rt");
   if (fp == NULL)
      err = FILE_NOT_FOUND;

   char line[MAX_KEY_LEN+MAX_VALUE_LEN];
   char key[MAX_KEY_LEN],value[MAX_VALUE_LEN];

   while (fgets(line,MAX_KEY_LEN+MAX_VALUE_LEN,fp) != NULL && strcmp(line,"\n")) {
      
      char *ptr = strchr(line,'=');
      
      if (!ptr) {
         err = ILLEGAL_ARGUMENT_IN_FILE;
         fclose(fp);
         return;
      }

      strcpy(value,ptr+1);
      if (value[strlen(value)-1] == 10)          // HACK !!
         value[strlen(value)-1] = '\0';
      *ptr = '\0';
      strcpy(key,line);
      
      table.insert(StrStrMap::value_type(key,value));
   }

   fclose(fp);
}

void PropReader :: getString(const char *name,char *value) {
   StrStrMap::iterator i = table.find(name);
   if (i != table.end())
      strncpy(value,(*i).second.c_str(),MAX_VALUE_LEN);
   else
      *value = NULL;
} 

int PropReader :: getInt(const char *name) {
   char value[MAX_VALUE_LEN+1];
   getString(name,value);
   return atoi(value);
} 

float PropReader :: getFloat(const char *name) {
   char value[MAX_VALUE_LEN+1];
   getString(name,value);
   return atof(value);
} 


int PropReader :: getError() {
   
   int e = err;
   err = 0;
   return e;

}